import {
	ClassicEditor,
	AccessibilityHelp,
	Alignment,
	Autosave,
	BlockQuote,
	Bold,
	CloudServices,
	Essentials,
	ImageBlock,
	ImageInsert,
	ImageInsertViaUrl,
	ImageResize,
	ImageStyle,
	ImageToolbar,
	ImageUpload,
	Indent,
	IndentBlock,
	Italic,
	Link,
	LinkImage,
	List,
	MediaEmbed,
	Paragraph,
	SelectAll,
	SimpleUploadAdapter,
	SpecialCharacters,
	SpecialCharactersArrows,
	SpecialCharactersCurrency,
	SpecialCharactersEssentials,
	SpecialCharactersLatin,
	SpecialCharactersMathematical,
	SpecialCharactersText,
	Strikethrough,
	Subscript,
	Superscript,
	Underline,
	Undo
} from 'ckeditor5';

const editorConfig = {
	toolbar: {
		items: [
			'undo',
			'redo',
			'|',
			'selectAll',
			'|',
			'bold',
			'italic',
			'underline',
			'strikethrough',
			'subscript',
			'superscript',
			'|',
			'numberedList',
			'bulletedList',
			'|',
			'specialCharacters',
			'link',
			'insertImage',
			'mediaEmbed',
			'blockQuote',
			'|',
			'alignment',
			'|',
			'indent',
			'outdent',
			'|',
			'accessibilityHelp'
		],
		shouldNotGroupWhenFull: false
	},
	plugins: [
		AccessibilityHelp,
		Alignment,
		Autosave,
		BlockQuote,
		Bold,
		List,
		CloudServices,
		Essentials,
		ImageBlock,
		ImageInsert,
		ImageInsertViaUrl,
		ImageResize,
		ImageStyle,
		ImageToolbar,
		ImageUpload,
		Indent,
		IndentBlock,
		Italic,
		Link,
		LinkImage,
		MediaEmbed,
		Paragraph,
		SelectAll,
		SimpleUploadAdapter,
		SpecialCharacters,
		SpecialCharactersArrows,
		SpecialCharactersCurrency,
		SpecialCharactersEssentials,
		SpecialCharactersLatin,
		SpecialCharactersMathematical,
		SpecialCharactersText,
		Strikethrough,
		Subscript,
		Superscript,
		Underline,
		Undo
	],
	placeholder: 'Type or paste your content here!',
	simpleUpload: {
    uploadUrl: upload_url,
  }
};

ClassicEditor
.create(document.querySelector('.ckeditor-custom'), editorConfig)
.then(editor => {
  window.editorInstance = editor;
})
.catch( error => {
  console.error( error );
});
