<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\GlobalHelper;
use App\Models\BahanBaku;
use Session;
use DB;

class ApiController extends Controller
{
    public function get_wilayah($level,$parent,$selected = null ){
      $data = DB::table('wilayah')->where('level','=',$level)
          ->where('parent_id', '=', $parent)
          ->orderby('nama_wilayah', 'asc')
          ->get();
      if(!empty($selected)){
        $check = DB::table('wilayah')->where('level','=',$level)
            ->where('parent_id', '=', $parent)
            ->where('id',$selected)
            ->first();
        $selected = (!empty($check) ? $check->id : null );
      }
      else{
        $selected = null ;
      }
      return array('data'=>$data,'selected'=>$selected);
    }

    public function find_bahan_baku($id){
      $data=DB::table('bahan_baku')->select('bahan_baku.*','satuan_bahan_baku.satuan','satuan_bahan_baku.satuan_komposisi')
        ->join('satuan_bahan_baku', function ($join) {
            $join->on('bahan_baku.fid_satuan', '=', 'satuan_bahan_baku.id')->whereNull('satuan_bahan_baku.deleted_at');
        })->where('bahan_baku.id',$id)->first();
      if(!empty($data)){
        if(!empty($data->gambar)){
          $data->gambar=url('storage/'.$data->gambar);
        }
        else{
          $data->gambar=asset('assets/images/image-default.jpg');
        }
        $data->harga_beli = number_format($data->harga_beli,0,',','.');
      }
      return response()->json($data);
    }

    public function find_pembelian_bahan_baku($id){
      $data=DB::table('pembelian_bahan_baku')->find($id);
      if(!empty($data)){
        $data->tanggal = GlobalHelper::dateFormat($data->tanggal,'d-m-Y');
        $data->harga_beli = number_format($data->harga_beli,0,',','.');
      }
      return response()->json($data);
    }

    public function find_pemasok_bahan_baku($id){
      $data=DB::table('pemasok_bahan_baku')->find($id);
      return response()->json($data);
    }

    public function find_menu_makanan($id){
      $data=DB::table('menu_makanan')->find($id);
      if(!empty($data)){
        if(!empty($data->gambar)){
          $data->gambar=url('storage/'.$data->gambar);
        }
        else{
          $data->gambar=asset('assets/images/image-default.jpg');
        }
      }
      return response()->json($data);
    }

    public function find_komposisi_makanan($id){
      $data=DB::table('komposisi_menu_makanan')->find($id);
      return response()->json($data);
    }

    public function find_nutrisi_makanan($id){
      $data=DB::table('nutrisi_menu_makanan')->find($id);
      return response()->json($data);
    }

    public function find_daftar_nutrisi($id){
      $data=DB::table('daftar_nutrisi')->find($id);
      return response()->json($data);
    }

    public function find_kategori_bahan_baku($id){
      $data=DB::table('kategori_bahan_baku')->find($id);
      return response()->json($data);
    }

    public function find_satuan_bahan_baku($id){
      $data=DB::table('satuan_bahan_baku')->find($id);
      return response()->json($data);
    }

    public function find_periode_semester($id){
      $data=DB::table('semester')->find($id);
      if(!empty($data)){
        $tahun = explode('/',$data->tahun_pelajaran);
        $data->tahun_awal = $tahun[0];
        $data->tahun_akhir = $tahun[1];
        $data->tanggal_mulai = GlobalHelper::dateFormat($data->tanggal_mulai,'d-m-Y');
        $data->tanggal_akhir = GlobalHelper::dateFormat($data->tanggal_akhir,'d-m-Y');
      }
      return response()->json($data);
    }

    public function find_user($id){
      $data=DB::table('user')->find($id);
      if(!empty($data)){
        if(!empty($data->foto)){
          $data->foto=url('storage/'.$data->foto);
        }
        else{
          $data->foto=asset('assets/images/user-avatar-placeholder.png');
        }
      }
      return response()->json($data);
    }
}
