<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\GlobalHelper;
use App\Models\User;
use App\Models\BahanBaku;
use App\Models\DaftarNutrisi;
use App\Models\MenuMakanan;
use App\Models\KomposisiMenuMakanan;
use App\Models\NutrisiMenuMakanan;
use App\Models\JadwalMenuMakanan;
use App\Models\ProsesPengolahan;
use App\Models\PenggunaanBahanBaku;
use App\Models\CounterDapur;
use App\Models\PengirimanMakanan;
use Session;
use DB;

class DapurController extends Controller
{
    // -------------------------- MENU MAKANAN --------------------------------//

    public function menu_makanan(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['menu-makanan'] = $this->get_menu_makanan($search);
      return view('dapur.menu_makanan.index')
        ->with('data',$data)
        ->with('search',$search)
        ->with('menu','Dapur Makanan')
        ->with('submenu','Menu Makanan');
    }

    public function get_menu_makanan($search,$limit=10){
      $query=MenuMakanan::select('*');
      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
          $i->where('nama_menu', 'like', "%{$search}%")
            ->orwhere('deskripsi', 'like', "%{$search}%");
        });
      }
      $result=$query->whereNull('deleted_at')->orderBy('nama_menu','DESC')->paginate($limit);
      return $result;
    }

    public function detail_menu_makanan(Request $request){
      $menu_makanan=MenuMakanan::select('*')->whereNull('deleted_at')->where('id',$request->id)->first();
      if(!empty($menu_makanan)){

        $data['bahan-baku'] = BahanBaku::whereNull('deleted_at')->get();
        $data['daftar-nutrisi'] = DaftarNutrisi::whereNull('deleted_at')->get();

        $data['komposisi'] = $this->get_komposisi($request->id);
        $data['nutrisi'] = $this->get_nutrisi($request->id);

        $data['menu-makanan'] = $menu_makanan;

        return view('dapur.menu_makanan.detail.index')
          ->with('data',$data)
          ->with('id',$request->id)
          ->with('menu','Dapur Makanan')
          ->with('submenu','Menu Makanan');
      }
      else{
        return redirect()->route('menu_makanan');
      }
    }

    public function get_komposisi($id,$jadwal_id=null){
      $data = KomposisiMenuMakanan::select('komposisi_menu_makanan.*','bahan_baku.nama_bahan','bahan_baku.gambar','satuan_bahan_baku.satuan','satuan_bahan_baku.satuan_komposisi','satuan_bahan_baku.formula_konversi')
        ->join('bahan_baku', function ($join) {
            $join->on('komposisi_menu_makanan.fid_bahan_baku','=','bahan_baku.id')
              ->join('satuan_bahan_baku', function ($join2) {
                  $join2->on('bahan_baku.fid_satuan', '=', 'satuan_bahan_baku.id')->whereNull('satuan_bahan_baku.deleted_at');
              })
              ->whereNull('bahan_baku.deleted_at');
        })
        ->whereNull('komposisi_menu_makanan.deleted_at')
        ->where('komposisi_menu_makanan.fid_menu_makanan',$id)
        ->get();

      $cek_jadwal = JadwalMenuMakanan::whereNull('deleted_at')->where('id',$jadwal_id)->first();
      foreach ($data as $key => $value) {
        $jumlah_porsi = (!empty($cek_jadwal) ? $cek_jadwal->jumlah : 0 );
        $jumlah_konversi = GlobalHelper::operasi($value->jumlah.''.$value->formula_konversi);
        $data[$key]->jumlah_konversi = $jumlah_konversi;
        $data[$key]->kebutuhan = $jumlah_konversi*$jumlah_porsi;
        $data[$key]->stok = GlobalHelper::stok_bahan_baku($value->fid_bahan_baku);
      }
      return $data;
    }

    public function get_nutrisi($id){
      $data = NutrisiMenuMakanan::select('nutrisi_menu_makanan.*','daftar_nutrisi.nama_nutrisi','daftar_nutrisi.satuan')
        ->join('daftar_nutrisi', function ($join) {
          $join->on('nutrisi_menu_makanan.fid_nutrisi','=','daftar_nutrisi.id')
            ->whereNull('daftar_nutrisi.deleted_at');
        })
        ->whereNull('nutrisi_menu_makanan.deleted_at')
        ->where('nutrisi_menu_makanan.fid_menu_makanan',$id)
        ->get();
      return $data;
    }

    public function proses_menu_makanan(Request $request){
      if($request->action=='add'){
        $field=new MenuMakanan;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Menu Makanan berhasil disimpan';
      }
      else{
        $field=MenuMakanan::find($request->id);
        if($request->action=='edit'){
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
          $msg='Menu Makanan berhasil disimpan';
        }
      }
      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Menu Makanan berhasil dihapus';
      }
      else{

        $field->nama_menu=$request->nama_menu;
        $field->deskripsi=$request->deskripsi;
        if($request->hasFile('gambar')){
          if (file_exists(storage_path('app/'.$field->gambar))) {
            if(!empty($field->gambar)){
              unlink(storage_path('app/'.$field->gambar));
            }
          }
          $uploadedFile = $request->file('gambar');
          $path = $uploadedFile->store('menu_makanan');
          $field->gambar=$path;
        }
      }
      $field->save();
      return redirect()->route('detail_menu_makanan',[ 'id' => $field->id ])
        ->with('message',$msg)
        ->with('message_type','success');
    }


    public function proses_komposisi_menu(Request $request){
      if($request->action=='add'){
        $field=new KomposisiMenuMakanan;
        $field->fid_menu_makanan = $request->menu_makanan;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Komposisi Menu Makanan berhasil disimpan';
      }
      else{
        $field=KomposisiMenuMakanan::find($request->id);
        if($request->action=='edit'){
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
          $msg='Komposisi Menu Makanan berhasil disimpan';
        }
      }
      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Komposisi Menu Makanan berhasil dihapus';
      }
      else{
        $field->fid_bahan_baku=$request->bahan_baku;
        $field->jumlah=str_replace(',','.',$request->jumlah);
      }
      $field->save();
      return redirect()->back()
        ->with('message',$msg)
        ->with('message_type','success');
    }

    public function proses_nutrisi_menu(Request $request){
      $cek_nutrisi = NutrisiMenuMakanan::where('fid_menu_makanan',$request->menu_makanan)->where('fid_nutrisi',$request->nutrisi)->first();
      if(!empty($cek_nutrisi)){
        $field=NutrisiMenuMakanan::find($cek_nutrisi->id);
        if($request->jumlah == 0 ){
          $field->deleted_at = date('Y-m-d H:i:s');
          $field->deleted_by = Session::get('useractive')->nama_lengkap;
          $field->deleted_by_id = Session::get('useractive')->id;
        }
        else{
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
          $field->deleted_at = null;
          $field->deleted_by = null;
          $field->deleted_by_id = null;
        }
        $field->jumlah=str_replace(',','.',$request->jumlah);
        $msg='Nutrisi Menu Makanan berhasil disimpan';
      }
      else{
        if($request->action=='add'){
          $field=new NutrisiMenuMakanan;
          $field->fid_menu_makanan = $request->menu_makanan;
          $field->created_at = date('Y-m-d H:i:s');
          $field->created_by = Session::get('useractive')->nama_lengkap;
          $field->created_by_id = Session::get('useractive')->id;
          $msg='Nutrisi Menu Makanan berhasil disimpan';
        }
        else{
          $field=NutrisiMenuMakanan::find($request->id);
          if($request->action=='edit'){
            $field->modified_at = date('Y-m-d H:i:s');
            $field->modified_by = Session::get('useractive')->nama_lengkap;
            $field->modified_by_id = Session::get('useractive')->id;
            $msg='Nutrisi Menu Makanan berhasil disimpan';
          }
        }
        if($request->action=='delete'){
          $field->deleted_at = date('Y-m-d H:i:s');
          $field->deleted_by = Session::get('useractive')->nama_lengkap;
          $field->deleted_by_id = Session::get('useractive')->id;
          $msg='Nutrisi Menu Makanan berhasil dihapus';
        }
        else{
          $field->fid_nutrisi=$request->nutrisi;
          $field->jumlah=str_replace(',','.',$request->jumlah);
        }
      }
      $field->save();
      return redirect()->back()
        ->with('message',$msg)
        ->with('message_type','success');
    }

    // ------------------------ JADWAL MENU MAKANAN ----------------------------//

    public function jadwal_menu(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['menu-makanan'] = MenuMakanan::whereNull('deleted_at')->get();
      $data['jadwal'] = $this->get_jadwal_menu($search);
      return view('dapur.jadwal.index')
        ->with('data',$data)
        ->with('search',$search)
        ->with('menu','Dapur Makanan')
        ->with('submenu','Jadwal Menu');
    }

    public function get_jadwal_menu($search,$limit=10){
      $query=JadwalMenuMakanan::select('jadwal_menu_makanan.*','menu_makanan.nama_menu','menu_makanan.deskripsi','menu_makanan.gambar','status_produksi.status_produksi','status_produksi.color')
        ->join('menu_makanan', function ($join) {
          $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
            ->whereNull('menu_makanan.deleted_at');
        })
        ->leftjoin('status_produksi', function ($join) {
          $join->on('jadwal_menu_makanan.fid_status','=','status_produksi.id')
            ->whereNull('status_produksi.deleted_at');
        });

      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
          $i->where('menu_makanan.nama_menu', 'like', "%{$search}%")
            ->orwhere('menu_makanan.deskripsi', 'like', "%{$search}%");
        });
      }
      $result=$query->whereNull('jadwal_menu_makanan.deleted_at')->orderBy('jadwal_menu_makanan.tanggal','DESC')->paginate($limit);
      return $result;
    }

    public function proses_jadwal_menu(Request $request){
      if($request->action=='add'){
        $field=new JadwalMenuMakanan;
        $field->fid_status = 0;
        $field->fid_menu_makanan = $request->menu_makanan;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Jadwal Menu Makanan berhasil disimpan';
      }
      else{
        $field=JadwalMenuMakanan::find($request->id);
        if($request->action=='edit'){
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
          $msg='Jadwal Menu Makanan berhasil disimpan';
        }
      }
      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Jadwal Menu Makanan berhasil dihapus';
      }
      else{
        $field->tanggal=GlobalHelper::dateFormat($request->tanggal,'Y-m-d');
        $field->jumlah=str_replace(',','.',$request->jumlah);
        $field->catatan=$request->catatan;
      }
      $field->save();
      return redirect()->back()
        ->with('message',$msg)
        ->with('message_type','success');
    }

    public function detail_jadwal_menu(Request $request){
      $jadwal_menu = JadwalMenuMakanan::select('jadwal_menu_makanan.*','menu_makanan.nama_menu','menu_makanan.deskripsi','menu_makanan.gambar','status_produksi.status_produksi','status_produksi.color')
        ->join('menu_makanan', function ($join) {
          $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
            ->whereNull('jadwal_menu_makanan.deleted_at');
        })
        ->leftjoin('status_produksi', function ($join) {
          $join->on('jadwal_menu_makanan.fid_status','=','status_produksi.id')
            ->whereNull('status_produksi.deleted_at');
        })
        ->where('jadwal_menu_makanan.id',$request->id)
        ->first();
      if(!empty($jadwal_menu)){
        $data['jadwal-menu'] = $jadwal_menu;
        if($request->page == 'form-pengiriman'){
          $data['driver'] = User::where('fid_hak_akses',3)->whereNull('deleted_at')->get();
          $penerima_controller = new PenerimaController;
          $penerima = $penerima_controller->get_penerima_manfaat(null,'all');
          $data['penerima-manfaat'] = $penerima;
        }
        else{
          $status_produksi = (!empty($jadwal_menu->fid_status) ? $jadwal_menu->fid_status : 0 ) + 1;
          $data['status-produksi'] = DB::table('status_produksi')->find($status_produksi);

          $komposisi = $this->get_komposisi($jadwal_menu->fid_menu_makanan,$jadwal_menu->id);
          $status_komposisi = 0;
          foreach ($komposisi as $key => $value) {
            $status = ( $value->stok >=  $value->kebutuhan ? 0 : ($status_produksi == 1 ? 1 : 0 ) );
            $komposisi[$key]->status = ( $status == 0 ? array('status'=>'Stok Cukup','color'=>'#16a085') : array('status'=>'Stok Kurang','color'=>'#c0392b') );
            $status_komposisi = $status_komposisi+$status;
          }
          // $cek_jadwal = JadwalMenuMakanan::whereNull('deleted_at')->where('id',$jadwal_menu->id)->first();
          // foreach ($komposisi as $key => $value) {
          //   $jumlah_porsi = (!empty($cek_jadwal) ? $cek_jadwal->jumlah : 0 );
          //   $jumlah_konversi = GlobalHelper::operasi($value->jumlah.''.$value->formula_konversi);
          //   $kebutuhan = $jumlah_konversi*$jumlah_porsi;
          //   $stok =  GlobalHelper::stok_bahan_baku($value->fid_bahan_baku);
          //   // $status = ( $stok >=  $kebutuhan ? array('status'=>'Stok Cukup','color'=>'#16a085') : array('status'=>'Stok Kurang','color'=>'#c0392b') );
          //   $status = ( $stok >=  $kebutuhan ? 0 : ($status_produksi == 1 ? 1 : 0 ) );
          //   $komposisi[$key]->jumlah_konversi = $jumlah_konversi;
          //   $komposisi[$key]->kebutuhan = $kebutuhan;
          //   $komposisi[$key]->status = ( $status == 0 ? array('status'=>'Stok Cukup','color'=>'#16a085') : array('status'=>'Stok Kurang','color'=>'#c0392b') );
          //   $status_komposisi = $status_komposisi+$status;
          // }

          $data['status_komposisi'] = $status_komposisi;
          $data['komposisi'] = $komposisi;
          $data['nutrisi'] = $this->get_nutrisi($jadwal_menu->fid_menu_makanan);
          $data['counter-pencucian'] = $this->get_counter_dapur('pencucian',$jadwal_menu->id);
          $data['counter-pengepakan'] = $this->get_counter_dapur('pengepakan',$jadwal_menu->id);
          $data['proses-pengolahan'] = $this->get_proses_pengolahan($request->id);
          $data['status'] = DB::table('status_produksi')->get();
        }
        return view('dapur.jadwal.detail.index')
          ->with('data',$data)
          ->with('id',$request->id)
          ->with('page',$request->page)
          ->with('menu','Dapur Makanan')
          ->with('submenu','Jadwal Menu');
      }
      else{
        return redirect()->route('jadwal_menu');
      }
    }

    public function get_counter_dapur($jenis,$jadwal_id){
      $data = CounterDapur::where('jenis',$jenis)->where('fid_jadwal_menu',$jadwal_id)->whereNull('deleted_at')->get();
      return $data;
    }

    public function proses_counter_dapur(Request $request,$jenis){
      $field = new CounterDapur;
      $field->jenis = $jenis;
      $field->fid_jadwal_menu = $request->jadwal_menu;
      $field->created_at = date('Y-m-d H:i:s');
      $field->created_by = Session::get('useractive')->nama_lengkap;
      $field->created_by_id = Session::get('useractive')->id;
      $field->jumlah = $request->jumlah;
      if($request->jumlah <= $request->belum){
        $field->save();
        return redirect()->back()
          ->with('message','Counter '.($jenis == 'pencucian' ? 'Pencucian Alat Makan' : 'Pengepakan Makanan' ).' berhasil disimpan')
          ->with('message_type','success');
      }
      else{
        return redirect()->back()
          ->with('message','Maaf, jumlah yang dimasukkan melebihi'.($jenis == 'pencucian' ? 'alat makan yang belum dicuci' : 'porsi makanan yang belum dikemas' ))
          ->with('message_type','warning');
      }

    }

    public function get_proses_pengolahan($id){
      $proses_terakhir = ProsesPengolahan::where('proses_pengolahan.fid_jadwal_menu',$id)->whereNull('proses_pengolahan.deleted_at')->orderBy('fid_status_produksi','DESC')->first();

      $data = ProsesPengolahan::select('proses_pengolahan.*',DB::raw('DATE(proses_pengolahan.created_at) as tanggal'))
        ->join('status_produksi', function ($join) {
          $join->on('proses_pengolahan.fid_status_produksi','=','status_produksi.id')
            ->whereNull('status_produksi.deleted_at');
        })
        ->where('proses_pengolahan.fid_jadwal_menu',$id)
        ->whereNull('proses_pengolahan.deleted_at')
        ->groupBy(DB::raw('DATE(proses_pengolahan.created_at)'))
        ->get();
      foreach ($data as $key => $value) {
        $timeline = ProsesPengolahan::select('proses_pengolahan.*','status_produksi.status_produksi')
          ->join('status_produksi', function ($join) {
            $join->on('proses_pengolahan.fid_status_produksi','=','status_produksi.id')
              ->whereNull('status_produksi.deleted_at');
          })
          ->where('proses_pengolahan.fid_jadwal_menu',$id)
          ->whereDate('proses_pengolahan.created_at',$value->tanggal )
          ->whereNull('proses_pengolahan.deleted_at')
          ->get();

        foreach ($timeline as $key2 => $value2) {
          $timeline[$key2]->status = (!empty($proses_terakhir) && $proses_terakhir->id == $value2->id ? 1 : 0 );
        }

        $data[$key]->timeline = $timeline;
      }
      return $data;
    }

    public function proses_pengolahan_makanan(Request $request){
      if($request->action=='add'){
        $field=new ProsesPengolahan;
        $field->fid_jadwal_menu = $request->jadwal_menu;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
      }
      else{
        $field=ProsesPengolahan::find($request->id);
        if($request->action=='edit'){
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
        }
      }
      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        if($request->status == 6 ){
          $this->batalkan_pengiriman($request->jadwal_menu);
        }
      }
      else{
        $field->fid_status_produksi=$request->status;
        $field->keterangan=$request->keterangan;
      }
      $field->save();
      $this->update_status_jadwal_menu($request->jadwal_menu);
      return redirect()->back();
    }

    public function batalkan_pengiriman($id){
      $pengiriman = PengirimanMakanan::where('fid_jadwal_menu',$id)->whereNull('deleted_at')->get();
      foreach ($pengiriman as $key => $value) {
        $field = PengirimanMakanan::find($value->id);
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $field->save();
      }
    }

    public function update_status_jadwal_menu($id){
      $cek_status = ProsesPengolahan::where('fid_jadwal_menu',$id)->orderBy('fid_status_produksi','desc')->whereNull('proses_pengolahan.deleted_at')->first();
      $status = (!empty($cek_status) ? $cek_status->fid_status_produksi : 0 );
      $field = JadwalMenuMakanan::find($id);
      $field->fid_status = $status;
      $field->modified_at = date('Y-m-d H:i:s');
      $field->modified_by = Session::get('useractive')->nama_lengkap;
      $field->modified_by_id = Session::get('useractive')->id;
      $field->save();
      if($field->fid_status == 1){
        $this->update_penggunaan_bahan_baku($id);
      }
      elseif($field->fid_status == 0 ){
        $this->pembatalan_penggunaan_bahan_baku($id);
      }
    }

    public function pembatalan_penggunaan_bahan_baku($id){
      $penggunaan = PenggunaanBahanBaku::where('fid_jadwal_menu',$id)->whereNull('deleted_at')->get();
      foreach ($penggunaan as $key => $value) {
        $field = PenggunaanBahanBaku::find($value->id);
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $field->save();
        $this->update_status_bahan_baku($value->fid_bahan_baku);
      }
    }

    public function update_penggunaan_bahan_baku($id){
      $jadwal=JadwalMenuMakanan::select('jadwal_menu_makanan.*','menu_makanan.nama_menu','menu_makanan.deskripsi','menu_makanan.gambar','status_produksi.status_produksi','status_produksi.color')
        ->join('menu_makanan', function ($join) {
          $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
            ->whereNull('jadwal_menu_makanan.deleted_at');
        })
        ->leftjoin('status_produksi', function ($join) {
          $join->on('jadwal_menu_makanan.fid_status','=','status_produksi.id')
            ->whereNull('status_produksi.deleted_at');
        })
        ->where('jadwal_menu_makanan.id',$id)
        ->whereNull('jadwal_menu_makanan.deleted_at')
        ->first();
      if(!empty($jadwal)){
        $bahan_baku = $this->get_komposisi($jadwal->fid_menu_makanan,$id);
        foreach ($bahan_baku as $key => $value) {
          $cek_penggunaan = PenggunaanBahanBaku::where('fid_bahan_baku',$value->fid_bahan_baku)->where('fid_jadwal_menu',$jadwal->fid_menu_makanan)->whereNull('deleted_at')->first();
          if(empty($cek_penggunaan)){
            $field = new PenggunaanBahanBaku;
            $field->created_at = date('Y-m-d H:i:s');
            $field->created_by = Session::get('useractive')->nama_lengkap;
            $field->created_by_id = Session::get('useractive')->id;
            $field->fid_bahan_baku = $value->fid_bahan_baku;
            $field->fid_jadwal_menu = $jadwal->fid_menu_makanan;
            $field->jumlah = $value->kebutuhan;
            $field->save();
          }
          $this->update_status_bahan_baku($value->fid_bahan_baku);
        }
      }
    }

    public function update_status_bahan_baku($id){
      $status = GlobalHelper::status_bahan_baku($id);
      $field = BahanBaku::find($id);
      $field->status = $status['status'];
      $field->modified_at = date('Y-m-d H:i:s');
      $field->modified_by = Session::get('useractive')->nama_lengkap;
      $field->modified_by_id = Session::get('useractive')->id;
      $field->save();
    }

}
