<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\GlobalHelper;
use Carbon\Carbon;
use App\Models\User;
use App\Models\BahanBaku;
use App\Models\KategoriBahanBaku;
use App\Models\PembelianBahanBaku;
use App\Models\SatuanBahanBaku;
use App\Models\PemasokBahanBaku;
use App\Models\DaftarNutrisi;
use App\Models\MenuMakanan;
use App\Models\KomposisiMenuMakanan;
use App\Models\NutrisiMenuMakanan;
use App\Models\JadwalMenuMakanan;
use App\Models\ProsesPengolahan;
use App\Models\PenggunaanBahanBaku;
use App\Models\PenerimaManfaat;
use App\Models\JumlahSiswa;
use Illuminate\Support\Str;
use Session;
use DB;

class DashboardController extends Controller
{
    public function index(Request $request,$submenu=null){
      $data['bahan-baku'] = $this->get_bahan_baku('Harus Restok',5);
      $data['jumlah-supplier'] = PemasokBahanBaku::whereNull('deleted_at')->count();
      $data['progres-produksi-makanan'] = $this->progres_produksi_makanan();
      $data['jumlah-sekolah'] = PenerimaManfaat::whereNull('deleted_at')->count();
      $data['jumlah-laki-laki'] = GlobalHelper::get_jumlah_siswa('all','laki_laki');
      $data['jumlah-perempuan'] = GlobalHelper::get_jumlah_siswa('all','perempuan');
      $data['jumlah-siswa'] = GlobalHelper::get_jumlah_siswa('all','all');
      $data['penerima-manfaat'] = $this->get_penerima_manfaat();
      if($submenu == null ){
        return view('dashboard.index')
          ->with('data',$data)
          ->with('menu','Dashboard')
          ->with('submenu','Dashboard');
      }
      else{
        return view('dashboard.'.$submenu)
          ->with('data',$data)
          ->with('menu','Dashboard')
          ->with('submenu','Dashboard');
      }
    }

    public function get_penerima_manfaat(){
      // Array kode warna
      $colorCodes = [
          '#16a085', '#2980b9', '#8e44ad', '#f39c12', '#c0392b',
          '#3742fa', '#130f40', '#be2edd', '#33FFBD', '#6ab04c',
      ];

      $data =  PenerimaManfaat::whereNull('deleted_at')->get();
      foreach ($data as $key => $value) {
        $data[$key]->color = $this->getRandomColorFromArray($colorCodes);
      }
      return $data;
    }

    public function getRandomColorFromArray($array){
      $randomIndex = array_rand($array); // Pilih index acak dari array
      return $array[$randomIndex]; // Kembalikan warna acak
    }


    public function progres_produksi_makanan(){
      $dapur = new  DapurController;
      $data = JadwalMenuMakanan::select('jadwal_menu_makanan.*','menu_makanan.nama_menu','menu_makanan.deskripsi','menu_makanan.gambar','status_produksi.status_produksi','status_produksi.color')
        ->join('menu_makanan', function ($join) {
          $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
            ->whereNull('menu_makanan.deleted_at');
        })
        ->leftjoin('status_produksi', function ($join) {
          $join->on('jadwal_menu_makanan.fid_status','=','status_produksi.id')
            ->whereNull('status_produksi.deleted_at');
        })
        ->where('jadwal_menu_makanan.tanggal',date('Y-m-d'))
        ->whereNull('jadwal_menu_makanan.deleted_at')
        ->first();
      if(!empty($data)){
        $data->komposisi = $dapur->get_komposisi($data->fid_menu_makanan);
        $data->nutrisi = $dapur->get_nutrisi($data->fid_menu_makanan);
      }
      return $data;
    }

    public function get_bahan_baku($status,$limit){
      $arr_status = array('kelebihan'=>'Kelebihan Stok','normal'=>'Stok Normal','rendah'=>'Stok Rendah','kritis'=>'Stok Kritis');
      $arr_color = array('kelebihan'=>'#8e44ad','normal'=>'#16a085','rendah'=>'#f39c12','kritis'=>'#c0392b');

      $query=BahanBaku::select('bahan_baku.*','satuan_bahan_baku.satuan','kategori_bahan_baku.nama_kategori')
        ->join('kategori_bahan_baku', function ($join) {
            $join->on('bahan_baku.fid_kategori', '=', 'kategori_bahan_baku.id')->whereNull('kategori_bahan_baku.deleted_at');
        })
        ->join('satuan_bahan_baku', function ($join) {
            $join->on('bahan_baku.fid_satuan', '=', 'satuan_bahan_baku.id')->whereNull('satuan_bahan_baku.deleted_at');
        });

      if($status == 'Harus Restok' ){
        $query=$query->where('bahan_baku.status','rendah')->orWhere('bahan_baku.status','kritis');
      }
      $result=$query->whereNull('bahan_baku.deleted_at')->orderBy('bahan_baku.nama_bahan','DESC')->limit($limit)->get();
      foreach ($result as $key => $value) {
        $result[$key]->stok = GlobalHelper::stok_bahan_baku($value->id);
        $result[$key]->kekurangan_stok = $value->stok_maksimum - GlobalHelper::stok_bahan_baku($value->id);
        $result[$key]->color = $arr_color[$value->status];
        $result[$key]->status = $arr_status[$value->status];
      }
      return $result;
    }
}
