<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Helpers\GlobalHelper;
use App\Models\KategoriBahanBaku;
use App\Models\SatuanBahanBaku;
use App\Models\Semester;
use View;
use DB;

class MasterController extends Controller
{
    // ----------------- KATEGORI BAHAN BAKU --------------------------//

    public function kategori_bahan_baku(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['kategori'] = $this->get_kategori_bahan_baku($search);
      return view('master.kategori_bahan_baku')
        ->with('search',$search)
        ->with('data',$data)
        ->with('menu','Data Master')
        ->with('submenu','Kategori Bahan Baku');
    }

    public function get_kategori_bahan_baku($search,$limit=10){
      $query=KategoriBahanBaku::select('*');
      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
            $i->where('nama_kategori', 'like', "%{$search}%");
         });
      }
      $result=$query->whereNull('deleted_at')->orderBy('nama_kategori')->orderBy('nama_kategori')->paginate(10);
      if(!empty($search)){
        $result->withPath('kategori_bahan_baku?search='.$search);
      }
      return $result;
    }

    public function proses_kategori_bahan_baku(Request $request){
      if($request->action=='add'){
        $field=new KategoriBahanBaku;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Kategori Bahan Baku berhasil ditambahkan';
      }
      else{
        $field=KategoriBahanBaku::find($request->id);
        $field->modified_at = date('Y-m-d H:i:s');
        $field->modified_by = Session::get('useractive')->nama_lengkap;
        $field->modified_by_id = Session::get('useractive')->id;
        $msg='Kategori Bahan Baku berhasil disimpan';
      }

      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Kategori Bahan Baku berhasil dihapus';
      }
      else{
        $field->nama_kategori=$request->nama_kategori;
        $field->keterangan=$request->keterangan;
      }
      $field->save();
      return redirect()->back()
        ->with('message',$msg)
        ->with('message_type','success');
    }

    // ----------------- SATUAN BAHAN BAKU --------------------------//

    public function satuan_bahan_baku(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['satuan'] = $this->get_satuan_bahan_baku($search);
      return view('master.satuan_bahan_baku')
        ->with('search',$search)
        ->with('data',$data)
        ->with('menu','Data Master')
        ->with('submenu','Satuan Bahan Baku');
    }

    public function get_satuan_bahan_baku($search,$limit=10){
      $query=SatuanBahanBaku::select('*');
      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
            $i->where('satuan', 'like', "%{$search}%")
              ->orWhere('satuan_komposisi', 'like', "%{$search}%");
         });
      }
      $result=$query->whereNull('deleted_at')->orderBy('satuan')->paginate(10);
      if(!empty($search)){
        $result->withPath('satuan_bahan_baku?search='.$search);
      }
      return $result;
    }

    public function proses_satuan_bahan_baku(Request $request){
      if($request->action=='add'){
        $field=new SatuanBahanBaku;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Satuan Bahan Baku berhasil ditambahkan';
      }
      else{
        $field=SatuanBahanBaku::find($request->id);
        $field->modified_at = date('Y-m-d H:i:s');
        $field->modified_by = Session::get('useractive')->nama_lengkap;
        $field->modified_by_id = Session::get('useractive')->id;
        $msg='Satuan Bahan Baku berhasil disimpan';
      }

      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Satuan Bahan Baku berhasil dihapus';
      }
      else{
        $field->satuan=$request->satuan;
        $field->satuan_komposisi=$request->satuan_komposisi;
        $field->formula_konversi=$request->formula_konversi;
      }
      $field->save();
      return redirect()->back()
        ->with('message',$msg)
        ->with('message_type','success');
    }

    // ----------------- PERIODE SEMESTER --------------------------//

    public function periode_semester(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['semester'] = $this->get_periode_semester($search);
      return view('master.periode_semester')
        ->with('search',$search)
        ->with('data',$data)
        ->with('menu','Data Master')
        ->with('submenu','Periode Semester');
    }

    public function get_periode_semester($search,$limit=10){
      $query=Semester::select('*');
      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
            $i->where('tahun_pelajaran', 'like', "%{$search}%")
              ->orWhere('semester', 'like', "%{$search}%");
         });
      }
      $result=$query->whereNull('deleted_at')->orderBy('tahun_pelajaran')->paginate(10);
      if(!empty($search)){
        $result->withPath('periode_semester?search='.$search);
      }
      return $result;
    }

    public function proses_periode_semester(Request $request){
      if( ($request->tahun_akhir == $request->tahun_awal + 1) || $request->action=='delete' ){
        if($request->action=='add'){
          $cek_semester = Semester::where('tahun_pelajaran',$request->tahun_awal.'/'.$request->tahun_akhir)->where('semester',$request->semester)->first();
          if(empty($cek_semester)){
            $field=new Semester;
            $field->created_at = date('Y-m-d H:i:s');
            $field->created_by = Session::get('useractive')->nama_lengkap;
            $field->created_by_id = Session::get('useractive')->id;
            $msg='Periode Semester berhasil ditambahkan';
          }
          else{
            return redirect()->back()
              ->with('message','Semester '.$request->semester.' Tahun Pelajaran '.$request->tahun_awal.'/'.$request->tahun_akhir.' sudah dibuat')
              ->with('message_type','warning');
          }
        }
        else{
          $cek_semester = Semester::where('tahun_pelajaran',$request->tahun_awal.'/'.$request->tahun_akhir)->where('semester',$request->semester)->where('id','!=',$request->id)->first();
          if(empty($cek_semester)){
            $field=Semester::find($request->id);
            $field->modified_at = date('Y-m-d H:i:s');
            $field->modified_by = Session::get('useractive')->nama_lengkap;
            $field->modified_by_id = Session::get('useractive')->id;
            $msg='Periode Semester berhasil disimpan';
          }
          else{
            return redirect()->back()
              ->with('message','Semester '.$request->semester.' Tahun Pelajaran '.$request->tahun_awal.'/'.$request->tahun_akhir.' sudah dibuat')
              ->with('message_type','warning');
          }
        }

        if($request->action=='delete'){
          $field->deleted_at = date('Y-m-d H:i:s');
          $field->deleted_by = Session::get('useractive')->nama_lengkap;
          $field->deleted_by_id = Session::get('useractive')->id;
          $msg='Periode Semester berhasil dihapus';
        }
        else{
          $field->tahun_pelajaran=$request->tahun_awal.'/'.$request->tahun_akhir;
          $field->semester=$request->semester;
          $field->tanggal_mulai=GlobalHelper::dateFormat($request->tanggal_mulai,'Y-m-d');
          $field->tanggal_akhir=GlobalHelper::dateFormat($request->tanggal_akhir,'Y-m-d');
        }
        $field->save();
        return redirect()->back()
          ->with('message',$msg)
          ->with('message_type','success');
      }
      else{
        return redirect()->back()
          ->with('message','Format tahun pelajaran tidak sesuai')
          ->with('message_type','warning');
      }
    }
}
