<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\GlobalHelper;
use App\Models\PenerimaManfaat;
use App\Models\JumlahSiswa;
use Carbon\Carbon;
use Session;
use DB;

class PenerimaController extends Controller
{
    public function index(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['jumlah-sekolah'] = PenerimaManfaat::whereNull('deleted_at')->count();
      // $data['status'] = array('Negeri','Swasta');
      // $data['kepilikan'] = array('pusat'=>'Pemerintah Pusat','provinsi'=>'Pemerintah Provinsi','kabupaten'=>'Pemerintah Kabupaten/Kota','yayasan'=>'Yayasan Non Pesantren','pesantren'=>'Yayasan Pondok Pesantren');
      // $data['bentuk'] = array('pgtk'=>'PG/TK','sd'=>'Sekolah Dasar (SD)','smp'=>'Sekolah Menengah Pertama (SMP)','sma'=>'Sekolah Menengah Atas (SMA)','smk'=>'Sekolah Menengah Kejuruan (SMK)');
      $data['penerima-manfaat'] = $this->get_penerima_manfaat($search,10);
      return view('penerima_manfaat.index')
        ->with('data',$data)
        ->with('search',$search)
        ->with('menu','Penerima Manfaat')
        ->with('submenu','Penerima Manfaat');
    }

    public function get_penerima_manfaat($search,$limit){
      $query=PenerimaManfaat::select('*');
      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
          $i->where('nama_sekolah', 'like', "%{$search}%")
            ->orwhere('npsn', 'like', "%{$search}%");
        });
      }
      if($limit == 'all' ){
        $result=$query->whereNull('deleted_at')->orderBy('nama_sekolah','ASC')->get();
      }
      else{
        $result=$query->whereNull('deleted_at')->orderBy('nama_sekolah','ASC')->paginate($limit);
      }
      foreach ($result as $key => $value) {
        $tanggal_cari = Carbon::parse(date('Y-m-d'));
        $semester = DB::table('semester')
                      ->whereDate('tanggal_mulai', '<=', $tanggal_cari)
                      ->whereDate('tanggal_akhir', '>=', $tanggal_cari)
                      ->first();

        $jumlah_siswa = JumlahSiswa::where('fid_penerima_manfaat',$value->id)
          ->where('fid_semester',(!empty($semester) ? $semester->id : 0 ))
          ->whereNull('deleted_at')
          ->first();

        $result[$key]->jumlah_laki_laki = (!empty($jumlah_siswa) ? $jumlah_siswa->jumlah_laki_laki : 0 );
        $result[$key]->jumlah_perempuan = (!empty($jumlah_siswa) ? $jumlah_siswa->jumlah_perempuan : 0 );
        $result[$key]->total = $result[$key]->jumlah_laki_laki + $result[$key]->jumlah_perempuan;
      }
      return $result;
    }

    public function form(Request $request){
      $data['semester'] = DB::table('semester')->get();
      $data['status'] = array('Negeri','Swasta');
      $data['kepemilikan'] = array('pusat'=>'Pemerintah Pusat','provinsi'=>'Pemerintah Provinsi','kabupaten'=>'Pemerintah Kabupaten/Kota','yayasan'=>'Yayasan Non Pesantren','pesantren'=>'Yayasan Pondok Pesantren');
      $data['bentuk'] = array('pgtk'=>'PG/TK','sd'=>'Sekolah Dasar (SD)','smp'=>'Sekolah Menengah Pertama (SMP)','sma'=>'Sekolah Menengah Atas (SMA)','smk'=>'Sekolah Menengah Kejuruan (SMK)');
      $data['penerima-manfaat'] = PenerimaManfaat::find($request->id);
      return view('penerima_manfaat.form')
        ->with('data',$data)
        ->with('menu','Penerima Manfaat')
        ->with('submenu','Penerima Manfaat');
    }

    public function proses(Request $request){
      if($request->action=='add'){
        $field=new PenerimaManfaat;
        $field->created_at = date('Y-m-d H:i:s');
        $field->created_by = Session::get('useractive')->nama_lengkap;
        $field->created_by_id = Session::get('useractive')->id;
        $msg='Penerima Manfaat berhasil disimpan';
      }
      else{
        $field=PenerimaManfaat::find($request->id);
        if($request->action=='edit'){
          $field->modified_at = date('Y-m-d H:i:s');
          $field->modified_by = Session::get('useractive')->nama_lengkap;
          $field->modified_by_id = Session::get('useractive')->id;
          $msg='Penerima Manfaat berhasil disimpan';
        }
      }
      if($request->action=='delete'){
        $field->deleted_at = date('Y-m-d H:i:s');
        $field->deleted_by = Session::get('useractive')->nama_lengkap;
        $field->deleted_by_id = Session::get('useractive')->id;
        $msg='Penerima Manfaat berhasil dihapus';
      }
      else{
        $field->npsn=$request->npsn;
        $field->nama_sekolah=$request->nama_sekolah;
        $field->status=$request->status;
        $field->kepemilikan=$request->kepemilikan;
        $field->bentuk=$request->bentuk;
        $field->sk_pendirian=$request->sk_pendirian;
        $field->tanggal_pendirian=GlobalHelper::dateFormat($request->tanggal_pendirian,'Y-m-d');
        $field->sk_izin_operasional=$request->sk_izin_operasional;
        $field->tanggal_izin_operasional=GlobalHelper::dateFormat($request->tanggal_izin_operasional,'Y-m-d');

        $field->alamat=$request->alamat;
        $field->latitude=$request->latitude;
        $field->longitude=$request->longitude;
        $field->rt=$request->rt;
        $field->rw=$request->rw;
        $field->fid_provinsi=$request->provinsi;
        $field->fid_kabupaten=$request->kabupaten;
        $field->fid_kecamatan=$request->kecamatan;
        $field->fid_desa=$request->desa;
        $field->kode_pos=$request->kode_pos;

        $field->nama_pic=$request->nama_pic;
        $field->no_telephone=$request->no_telephone;
        $field->email=$request->email;

        if($request->hasFile('logo')){
          if (file_exists(storage_path('app/'.$field->logo))) {
            if(!empty($field->logo)){
              unlink(storage_path('app/'.$field->logo));
            }
          }
          $uploadedFile = $request->file('logo');
          $path = $uploadedFile->store('penerima_manfaat');
          $field->logo=$path;
        }
      }

      $field->save();

      if($request->action){
        $jumlah_siswa = new JumlahSiswa;
        $jumlah_siswa->created_at = date('Y-m-d H:i:s');
        $jumlah_siswa->created_by = Session::get('useractive')->nama_lengkap;
        $jumlah_siswa->created_by_id = Session::get('useractive')->id;
        $jumlah_siswa->fid_penerima_manfaat = $field->id;
        $jumlah_siswa->fid_semester = $request->semester;
        $jumlah_siswa->jumlah_laki_laki = $request->jumlah_laki_laki;
        $jumlah_siswa->jumlah_perempuan = $request->jumlah_perempuan;
        $jumlah_siswa->save();
      }
      return redirect()->route('penerima_manfaat')
        ->with('message',$msg)
        ->with('message_type','success');
    }

    public function detail(Request $request){
      $penerima_manfaat = PenerimaManfaat::whereNull('deleted_at')->find($request->id);
      if(!empty($penerima_manfaat)){
        $data['status'] = array('Negeri','Swasta');
        $data['kepilikan'] = array('pusat'=>'Pemerintah Pusat','provinsi'=>'Pemerintah Provinsi','kabupaten'=>'Pemerintah Kabupaten/Kota','yayasan'=>'Yayasan Non Pesantren','pesantren'=>'Yayasan Pondok Pesantren');
        $data['bentuk'] = array('pgtk'=>'PG/TK','sd'=>'Sekolah Dasar (SD)','smp'=>'Sekolah Menengah Pertama (SMP)','sma'=>'Sekolah Menengah Atas (SMA)','smk'=>'Sekolah Menengah Kejuruan (SMK)');
        $penerima_manfaat->provinsi = GlobalHelper::find_info_wilayah($penerima_manfaat->fid_provinsi);
        $penerima_manfaat->kabupaten = GlobalHelper::find_info_wilayah($penerima_manfaat->fid_kabupaten);
        $penerima_manfaat->kecamatan = GlobalHelper::find_info_wilayah($penerima_manfaat->fid_kecamatan);
        $penerima_manfaat->desa = GlobalHelper::find_info_wilayah($penerima_manfaat->fid_desa);
        $data['penerima-manfaat'] = $penerima_manfaat;
        return view('penerima_manfaat.detail.index')
          ->with('tab',(!empty($request->tab) ? $request->tab : 'informasi' ))
          ->with('data',$data)
          ->with('menu','Penerima Manfaat')
          ->with('submenu','Penerima Manfaat');
      }
      else{
        return redirect()->route('penerima_manfaat');
      }
    }
}
