<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Helpers\GlobalHelper;
use App\Models\MenuMakanan;
use App\Models\JadwalMenuMakanan;
use App\Models\ProsesPengolahan;
use App\Models\PenggunaanBahanBaku;
use App\Models\CounterDapur;
use App\Models\PengirimanMakanan;
use Session;
use DB;

class PengirimanController extends Controller
{
    public function index(Request $request){
      $search = (!empty($request->search) ? $request->search : null );
      $data['pengiriman-makanan'] = $this->get_pengiriman_makanan($search);
      return view('pengiriman_makanan.index')
        ->with('data',$data)
        ->with('search',$search)
        ->with('menu','Pengiriman Makanan')
        ->with('submenu','Pengiriman Makanan');
    }

    public function get_pengiriman_makanan($search,$limit=10){
      $query=PengirimanMakanan::select('pengiriman_makanan.*','user.nama_lengkap','user.foto','user.nik','jadwal_menu_makanan.tanggal','menu_makanan.nama_menu','menu_makanan.deskripsi','menu_makanan.gambar','penerima_manfaat.nama_sekolah','penerima_manfaat.alamat','penerima_manfaat.rt','penerima_manfaat.rw','penerima_manfaat.logo')
      ->join('jadwal_menu_makanan', function ($join) {
        $join->on('pengiriman_makanan.fid_jadwal_menu','=','jadwal_menu_makanan.id')
          ->whereNull('jadwal_menu_makanan.deleted_at');
      })
      ->join('menu_makanan', function ($join) {
        $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
          ->whereNull('menu_makanan.deleted_at');
      })
      ->join('penerima_manfaat', function ($join) {
        $join->on('pengiriman_makanan.fid_penerima_manfaat','=','penerima_manfaat.id')
          ->whereNull('penerima_manfaat.deleted_at');
      })
      ->join('user', function ($join) {
        $join->on('pengiriman_makanan.fid_pengemudi','=','user.id')
          ->whereNull('user.deleted_at');
      });

      if(!empty($search)){
        $query=$query->where(function ($i) use ($search) {
          $i->where('menu_makanan.nama_menu', 'like', "%{$search}%")
            ->orwhere('user.nama_lengkap', 'like', "%{$search}%");
        });
      }
      $result=$query->whereNull('pengiriman_makanan.deleted_at')->orderBy('pengiriman_makanan.created_at','DESC')->paginate($limit);
      return $result;
    }

    public function proses(Request $request){
      $dapur_controller = new DapurController;
      if($request->action == 'add' ){
        foreach ($request->penerima as $id) {
          $field = new PengirimanMakanan;
          $field->created_at = date('Y-m-d H:i:s');
          $field->created_by = Session::get('useractive')->nama_lengkap;
          $field->created_by_id = Session::get('useractive')->id;
          $field->fid_jadwal_menu = $request->jadwal;
          $field->fid_penerima_manfaat = $id;
          $field->fid_pengemudi = $request->pengemudi[$id];
          $field->jumlah = $request->jumlah[$id];
          $field->status = 'Persiapan Pengiriman';
          $field->save();
        }
        $status = new ProsesPengolahan;
        $status->fid_jadwal_menu = $request->jadwal;
        $status->created_at = date('Y-m-d H:i:s');
        $status->created_by = Session::get('useractive')->nama_lengkap;
        $status->created_by_id = Session::get('useractive')->id;
        $status->fid_status_produksi=5;
        $status->save();
        $dapur_controller->update_status_jadwal_menu($request->jadwal);
        return redirect()->route('detail_jadwal_menu',['id'=>$request->jadwal])
          ->with('message','Pengiriman makanan berhasil diproses')
          ->with('message_type','success');
      }
      else{

      }
    }

    public function detail(Request $request){
      $pengiriman=PengirimanMakanan::select('pengiriman_makanan.*','user.nama_lengkap','user.foto','user.nik',
        'jadwal_menu_makanan.tanggal','menu_makanan.nama_menu','menu_makanan.deskripsi',
        'menu_makanan.gambar','penerima_manfaat.nama_sekolah','penerima_manfaat.alamat',
        'penerima_manfaat.rt','penerima_manfaat.rw','penerima_manfaat.logo','penerima_manfaat.latitude','penerima_manfaat.longitude')
        ->join('jadwal_menu_makanan', function ($join) {
          $join->on('pengiriman_makanan.fid_jadwal_menu','=','jadwal_menu_makanan.id')
            ->whereNull('jadwal_menu_makanan.deleted_at');
        })
        ->join('menu_makanan', function ($join) {
          $join->on('jadwal_menu_makanan.fid_menu_makanan','=','menu_makanan.id')
            ->whereNull('menu_makanan.deleted_at');
        })
        ->join('penerima_manfaat', function ($join) {
          $join->on('pengiriman_makanan.fid_penerima_manfaat','=','penerima_manfaat.id')
            ->whereNull('penerima_manfaat.deleted_at');
        })
        ->join('user', function ($join) {
          $join->on('pengiriman_makanan.fid_pengemudi','=','user.id')
            ->whereNull('user.deleted_at');
        })->where('pengiriman_makanan.id',$request->id)->whereNull('pengiriman_makanan.deleted_at')->first();

      if(!empty($pengiriman)){
        $data['pengiriman'] = $pengiriman;
        return view('pengiriman_makanan.detail.index')
          ->with('data',$data)
          ->with('menu','Pengiriman Makanan')
          ->with('submenu','Pengiriman Makanan');
      }
      else{
        return redirect()->route('pengiriman_makanan');
      }
    }
}
