@extends('layouts.main')
@section('css')
  <style>
  @media (min-width: 768px){
    .timeline-label {
      margin-left: 80px;
    }
    .timeline-time {
      width: 80px;
    }
    .timeline-item + .timeline-item::before {
      left: 80px;
    }
  }
  .timeline-body::before{
    border: 2px solid #455b00;
  }
  .timeline-body h6{
    color: #455b00;
    margin-bottom: 5px;
  }
  </style>
@endsection
@section('content')
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
      <img src="{{(!empty($data['jadwal-menu']->gambar) ? asset('storage/'.$data['jadwal-menu']->gambar) : asset('assets/images/image-default.jpg') )}}" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <div class="mg-b-5 tx-15">{{$data['jadwal-menu']->jumlah}} Porsi</div>
      <h5 class="mg-b-5 tx-20">{{$data['jadwal-menu']->nama_menu}}</h5>
      @if(!empty($data['jadwal-menu']->status_produksi))
      <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:{{ $data['jadwal-menu']->color }}"> {{ $data['jadwal-menu']->status_produksi }} </span>
      @else
      <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
      @endif
    </div>
  </div>
  <div class="card {{ ($page == 'form-pengiriman' ? 'card-table' : null) }} rounded-20" style="min-height: calc(100vh - 275px )">
    @if($page == 'form-pengiriman')
      <div class="pd-30">
        <h5>Form Pengiriman Makanan</h5>
        <p class="mg-b-0">Silahkan tentukan pengemudi untuk setiap tujuan dari penerima manfaat</p>
      </div>
      <form action="{{ route('proses_pengiriman') }}" method="post">
        {{ csrf_field() }}
        <table class="table table-vertical-middle">
          <thead class="thead-light">
            <tr>
              <th width="50px">No</th>
              <th>Penerima Manfaat</th>
              <th width="80px" class="tx-center">Jumlah<br>Porsi</th>
              <th width="300px">Nama Pengemudi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($data['penerima-manfaat'] as $key => $value)
              <tr>
                <td>{{ $key+1 }}</td>
                <td>
                  <div class="media">
                    <div class="image-wrapper rounded mg-r-10 " style="aspect-ratio:1/1;width:60px;padding:3px">
                      <img src="{{ (!empty($value->logo) ? asset('storage/'.$value->logo) : asset('assets/images/image-default.jpg') ) }}" alt="">
                    </div>
                    <div class="media-body align-self-center ">
                      <h6>{{$value->nama_sekolah}}</h6>
                      <div>{!! (!empty($value->alamat) ? $value->alamat : '---' ) !!}, RT {{ $value->rt }} / RW {{ $value->rw }}</div>
                    </div>
                  </div>
                </td>
                <td class="tx-center">{{ $value->total }}</td>
                <td>
                  <input type="hidden" name="penerima[]" value="{{ $value->id }}">
                  <input type="hidden" name="jumlah[{{ $value->id }}]" value="{{ $value->total }}">
                  <select class="select2 form-control" name="pengemudi[{{ $value->id }}]">
                    @foreach ($data['driver'] as $key => $value)
                    <option value="{{$value->id}}">{{ $value->nama_lengkap }}</option>
                    @endforeach
                  </select>
                </td>
              </tr>
            @endforeach
          </tbody>
        </table>
        <hr>
        <div class="pd-x-30 pd-b-20">
          <div class="row">
            <div class="col-md-12">
              <div class="pull-right">
                <input type="hidden" name="jadwal" value="{{ $data['jadwal-menu']->id }}">
                <a class="btn btn-dark" href="{{ route('detail_jadwal_menu',['id'=>$data['jadwal-menu']->id]) }}">Kembali</a>
                <button class="btn btn-primary" name="action" value="add" >Simpan</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    @else
    <div class="card-body pd-0">
      <div class="row row-xs">
        <div class="col-md-5">
          <div class="pd-30">
            <h5 class="mg-b-15">Komposisi Makanan</h5>
            <table class="table table-vertical-middle">
              <tbody>
                @foreach ($data['komposisi'] as $key => $value)
                  <tr>
                    <td style="{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                      <div class="media">
                        <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                          <img src="{{ url('storage/'.$value->gambar) }}" alt="">
                        </div>
                        <div class="media-body align-self-center ">
                          <h6>{{$value->nama_bahan}}</h6>
                          <div>{{$value->jumlah}} {{$value->satuan_komposisi}}</div>
                        </div>
                      </div>
                    </td>
                    <td style="text-align:right;{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                      <span class="tx-11 tx-white rounded pd-x-8 pd-y-3 mg-b-5" style="background:{{$value->status['color']}}">{{$value->status['status']}}</span>
                      <div>{{ $value->kebutuhan }} {{ $value->satuan }}</div>
                    </td>
                  </tr>
                @endforeach
              </tbody>
            </table>
            {{-- <hr> --}}
            <h5 class="mg-b-15 mg-t-30">Kandungan Nutrisi</h5>
            <div class="row row-sm mg-b-30">
              @foreach ($data['nutrisi'] as $key => $value)
              <div class="col-md-6">
                <div class="card rounded-20 mg-b-20">
                  <div class="card-body pd-10 text-center">
                    <h3 class="tx-30 fw-bold">{{ $value->jumlah }}</h3>
                    <h5 class="tx-15">{{ $value->nama_nutrisi }}</h5>
                    <p class="text-muted">{{ $value->satuan }}</p>
                  </div>
                </div>
              </div>
              @endforeach
            </div>
          </div>
        </div>
        <div class="col-md-7">
          @if($data['status_komposisi'] == 0 )
          <div class="bg-gray-700 pd-30 ht-100p" style="border-radius:0 20px 20px 0">
            <div class="row mg-b-15">
              <div class="col-md-6">
                <h5 class="tx-white">Proses Produksi</h5>
              </div>
              <div class="col-md-6">
                @if(!empty($data['status-produksi']))
                  @if($data['status-produksi']->id == 5 )
                    <a class="btn btn-xs btn-primary pull-right" href="{{ route('detail_jadwal_menu',['id'=>$data['jadwal-menu']->id,'page'=>'form-pengiriman']) }}" >{{ $data['status-produksi']->button }}</a>
                  @else
                    <button class="btn btn-xs btn-primary pull-right" data-target = "#modal-proses-pengolahan" data-toggle="modal" >{{ $data['status-produksi']->button }}</button>
                  @endif
                @endif
              </div>
            </div>
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body">
                <div class="timeline-group tx-13">
                  @foreach ($data['proses-pengolahan'] as $key => $value)
                    <div class="timeline-label">{{ GlobalHelper::tgl_indo($value->tanggal) }}</div>
                    @foreach ($value->timeline as $key2 => $value2)
                      <div class="timeline-item">
                        <div class="timeline-time">{{ GlobalHelper::dateFormat($value2->created_at,'H:i') }}</div>
                        <div class="timeline-body">
                          <h6 class="mg-b-0">{{ $value2->status_produksi }}</h6>
                          <p class="mg-b-5">{{ (!empty($value2->keterangan) ? $value2->keterangan : 'Tidak ada Catatan' ) }}</p>
                          @if($value2->status == 1 )
                            <button class="btn btn-primary btn-xs">Ubah Catatan</button>
                            <button class="btn btn-danger btn-xs" onclick="batalkanProses({{$value2->id}})">Batalkan Proses</button>
                            <form action="{{ route('proses_pengolahan_makanan',['jadwal_menu'=>$id,'status'=>(!empty($data['status-produksi']) ? $data['status-produksi']->id : null )]) }}" method="post" id="batalkan{{$value2->id}}">
                              {{ csrf_field() }}
                              <input type="hidden" name="id" value="{{$value2->id}}">
                              <input type="hidden" name="action" value="delete">
                            </form>
                          @endif
                        </div>
                      </div>
                    @endforeach
                  @endforeach
                </div>
              </div>
            </div>
            <div class="row row-sm mg-t-20">
          <div class="col-md-6">
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body tx-center">
                <h6>Pencucian Alat Makan</h6>
                <div id="progres_cuci_piring"></div>
                <div class="row row-xs mg-t-30">
                  <div class="col-md-6">
                    <button class="btn btn-primary btn-block btn-xs" data-target = "#modal-proses-pencucian" data-toggle="modal">Tambahkan<br>Proses</button>
                  </div>
                  <div class="col-md-6">
                    <button class="btn btn-secondary btn-block btn-xs" data-target = "#modal-tampilkan-proses-pencucian" data-toggle="modal">Tampilkan<br>Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body tx-center">
                <h6>Pemorsian / Pengepakan</h6>
                <div id="progres_pengemasan"></div>
                <div class="row row-xs mg-t-30">
                  <div class="col-md-6">
                    <button class="btn btn-primary btn-block btn-xs" data-target = "#modal-proses-pengepakan" data-toggle="modal">Tambahkan<br>Proses</button>
                  </div>
                  <div class="col-md-6">
                    <button class="btn btn-secondary btn-block btn-xs" data-target = "#modal-tampilkan-proses-pengepakan" data-toggle="modal">Tampilkan<br>Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
          </div>
          @else
          <div class="bg-gray-300 pd-50 ht-100p" style="border-radius:0 20px 20px 0">
            <div class="tx-center mg-t-50">
              <img src="{{ asset('assets/images/groceries.png') }}" style="width:200px">
              <h4 class="mg-t-20">MENU MAKANAN BELUM BISA DIPROSES</h4>
              <p>Bahan baku tidak mencukupi untuk memproses menu makanan ini, segera melakukan pembelian atau restok bahan baku</p>
            </div>
          </div>
          @endif
        </div>
      </div>
    </div>
    @endif
  </div>

  @if($page != 'form-pengiriman')

  <div class="modal fade" id="modal-proses-pengolahan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Konfirmasi Proses Pengolahan</h5>
          <p>{{ (!empty($data['status-produksi']) ? $data['status-produksi']->pertanyaan.'?' : null ) }}</p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_pengolahan_makanan',['jadwal_menu'=>$id,'status'=>(!empty($data['status-produksi']) ? $data['status-produksi']->id : null )]) }}" method="post" enctype="multipart/form-data">
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Keterangan</label>
              <textarea class="form-control" name="keterangan"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-proses-pencucian" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Proses Pencucian Alat Makan</h5>
          <p>Masukkan jumlah alat makan yang sudah diproses</p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_counter_dapur',['jenis'=>'pencucian','jadwal_menu'=>$id]) }}" method="post" enctype="multipart/form-data">
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Total Alat Makan</label>
                  <input type="text" class="form-control" value="{{ GlobalHelper::get_counter_dapur('pencucian',$id)['total'] }}" disabled >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Sudah Dicuci</label>
                  <input type="text" class="form-control" value="{{ GlobalHelper::get_counter_dapur('pencucian',$id)['sudah'] }}" disabled >
                </div>
              </div>
            </div>
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Belum Dicuci</label>
                  <input type="text" class="form-control" name="belum" value="{{ GlobalHelper::get_counter_dapur('pencucian',$id)['belum'] }}" readonly >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Barusan Dicuci</label>
                  <input type="text" class="form-control" name="jumlah"  >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-tampilkan-proses-pencucian" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Data Progress Pencucian Alat Makan</h5>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pd-0">
          <div class="card-table">
            <table class="table" style="margin-top:0px !important ;">
              <thead class="thead-light">
                <tr>
                  <th width="50px">No</th>
                  <th width="150px">Waktu</th>
                  <th class="tx-center">Jumlah</th>
                  <th>Petugas</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($data['counter-pencucian'] as $key => $value)
                  <tr>
                    <td>{{ $key+1 }}</td>
                    <td>{{ GlobalHelper::dateFormat($value->created_at,'d/m/Y, H:i') }}</td>
                    <td style="width:1px;white-space:nowrap" class="tx-center">{{ $value->jumlah }}</td>
                    <td>{{ $value->created_by }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
          <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
        </div>
      </div>
    </div>
  </div>


  <div class="modal fade" id="modal-proses-pengepakan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Proses Pengepakan Makanan</h5>
          <p>Masukkan jumlah porsi makanan yang sudah dikemas</p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_counter_dapur',['jenis'=>'pengepakan','jadwal_menu'=>$id]) }}" method="post" enctype="multipart/form-data">
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Total Porsi</label>
                  <input type="text" class="form-control" value="{{ GlobalHelper::get_counter_dapur('pengepakan',$id)['total'] }}" disabled >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Sudah Dikemas</label>
                  <input type="text" class="form-control" value="{{ GlobalHelper::get_counter_dapur('pengepakan',$id)['sudah'] }}" disabled >
                </div>
              </div>
            </div>
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Belum Dikemas</label>
                  <input type="text" class="form-control" name="belum" value="{{ GlobalHelper::get_counter_dapur('pengepakan',$id)['belum'] }}" readonly >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Barusan Dikemas</label>
                  <input type="text" class="form-control" name="jumlah"  >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-tampilkan-proses-pengepakan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Data Progress Pengepakan Makanan</h5>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pd-0">
          <div class="card-table">
            <table class="table" style="margin-top:0px !important ;">
              <thead class="thead-light">
                <tr>
                  <th width="50px">No</th>
                  <th width="150px">Waktu</th>
                  <th class="tx-center">Jumlah</th>
                  <th>Petugas</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($data['counter-pengepakan'] as $key => $value)
                  <tr>
                    <td>{{ $key+1 }}</td>
                    <td>{{ GlobalHelper::dateFormat($value->created_at,'d/m/Y, H:i') }}</td>
                    <td style="width:1px;white-space:nowrap" class="tx-center">{{ $value->jumlah }}</td>
                    <td>{{ $value->created_by }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
          <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
        </div>
      </div>
    </div>
  </div>

  @endif
@endsection
@section('js')
  <script src="{{asset('assets/lib/apexcharts/apexcharts.min.js')}}"></script>
  <script>
  get_chart_progres_cuci_piring({{ GlobalHelper::get_counter_dapur('pencucian',$id)['persentase'] }});
  function get_chart_progres_cuci_piring(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pencucian',$id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_cuci_piring"), options);
    chart.render();
  }

  get_chart_progres_pengemasan({{ GlobalHelper::get_counter_dapur('pengepakan',$id)['persentase'] }});
  function get_chart_progres_pengemasan(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pengepakan',$id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_pengemasan"), options);
    chart.render();
  }

  function batalkanProses(id){
    swal({
       title: "Are you sure?",
       text: "Apakah anda yakin ingin membatalkan proses ini",
       icon: "warning",
       buttons: true,
       dangerMode: true,
     })
     .then((willDelete) => {
      if (willDelete) {
        $('#batalkan'+id).submit();
      }
    });
  }
  </script>
@endsection
