@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" id="search" placeholder="Cari Menu Makanan">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-4">
            <button class="btn btn-primary pull-right" onclick="add_jadwal_menu()">Tambah Menu Makanan</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th class="tx-center">Tanggal</th>
            <th>Menu Makanan</th>
            <th class="tx-center" width="100px" >Jumlah</th>
            <th class="tx-center" >Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['jadwal'] as $key => $value)
            <tr>
              <td>{{ $data['jadwal']->firstItem() + $key }}</td>
              <td class="tx-center">
                <h6>{{GlobalHelper::nama_hari($value->tanggal)}}</h6>
                <div>{{ GlobalHelper::dateFormat($value->tanggal,'d/m/Y') }}</div>
              </td>
              <td>
                <div class="media">
                  <div class="image-wrapper rounded mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                    <img src="{{(!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )}}" class="rounded" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <h6>{{$value->nama_menu}}</h6>
                    <div class="text-truncated-1">{{$value->deskripsi}}</div>
                  </div>
                </div>
              </td>
              <td class="tx-center">{{ $value->jumlah }}<br>Porsi</td>
              <td class="tx-center">
                @if(!empty($value->status_produksi))
                <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:{{ $value->color }}"> {{ $value->status_produksi }} </span>
                @else
                <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
                @endif
              </td>
              <td style="width:1px;white-space:nowrap;">
                <div style="height:32px;">
                  <a href="{{ route('detail_jadwal_menu',['id'=>$value->id]) }}" class="button dark ripple-effect ico">
                    <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                  </a>
                  {{-- <a href="javascript:;" onclick="edit_jadwal_menu({{$value->id}})" class="button green ripple-effect ico">
                    <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                  </a> --}}
                  <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                    <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                  </a>
                </div>
                <form action="{{ route('proses_jadwal_menu') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['jadwal']->links('include.pagination', ['pagination' => $data['jadwal']] ) }}</div>
    </div>
  </div>

  <div class="modal fade" id="modal-jadwal-menu" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_jadwal_menu') }}" method="post" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="row row-xs">
              <div class="col-md-4">
                <div class="form-group">
                  <label>Tanggal</label>
                  <input
                    type="text" class="form-control datepicker"
                    autocomplete="off" id="tanggal" name="tanggal"
                    required data-parsley-required-message="Tanggal tidak boleh kosong"
                    data-parsley-dateformat data-parsley-dateformat-message="Tanggal harus dalam format dd-mm-yyyy."
                  >
                </div>
              </div>
              <div class="col-md-8">
                <div class="form-group">
                  <label>Pilih Menu Makanan</label>
                  <select class="select2" style="width:100%" id="menu_makanan" name="menu_makanan">
                    @foreach ($data['menu-makanan'] as $key => $value)
                    <option value="{{ $value->id }}">{{ $value->nama_menu }}</option>
                    @endforeach
                  </select>
                </div>
              </div>
            </div>
            <div class="form-group">
              <label>Jumlah </label>
              <div class="input-group">
                <input type="text" class="form-control" id="jumlah" name="jumlah" readonly >
                <div class="input-group-append">
                  <span class="input-group-text">Paket</span>
                </div>
              </div>
              <span style="font-size:11px;color:#d22e2e">Jumlah porsi berdasarkan jumlah siswa dari penerima manfaat yang sudah terdaftar</span>
            </div>
            <div class="form-group mg-b-0">
              <label>Catatan</label>
              <textarea class="form-control" id="catatan" name="catatan" style="height:150px"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@endsection
@section('js')
<script>
Parsley.addValidator('dateformat', {
  validateString: function (value) {
    // Regex untuk format tanggal d-m-Y
    const dateRegex = /^([0-2][0-9]|(3)[0-1])-((0)[0-9]|(1)[0-2])-\d{4}$/;
    return dateRegex.test(value); // Valid jika regex cocok
  },
  messages: {
    en: "The date must be in the format dd-mm-yyyy.",
    id: "Tanggal harus dalam format dd-mm-yyyy."
  }
});

$('#tanggal').parsley();
function add_jadwal_menu(){
  $('#tanggal').val('{{ date('d-m-Y') }}');
  $('#jumlah').val({{ GlobalHelper::get_jumlah_siswa('all','all') }});
  $('#catatan').val('');
  $('#id').val(0);
  $('#action').val('add');
  $('#title').html('Tambah Jadwal Menu Makanan');
  $('#modal-jadwal-menu').modal('show');
}
</script>
@endsection
