@extends('layouts.main')
@section('content')
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
      <img src="{{(!empty($data['menu-makanan']->gambar) ? asset('storage/'.$data['menu-makanan']->gambar) : asset('assets/images/image-default.jpg') )}}" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <h5 class="mb-10 tx-30">{{$data['menu-makanan']->nama_menu}}</h5>
      <div class="mg-b-10">{{$data['menu-makanan']->deskripsi}}</div>
      <button class="btn btn-xs btn-primary" onclick="edit_menu_makanan({{ $id }})" >Edit Menu Makanan</button>
    </div>
  </div>
  <div class="card rounded-20" style="min-height: calc(100vh - 275px )">
    <div class="card-body pd-30">
      <div class="row row-lg">
        <div class="col-md-6">
          <div class="row mg-b-30">
            <div class="col-md-8">
              <h5>Komposisi Makanan</h5>
            </div>
            <div class="col-md-4">
              <button class="btn btn-xs btn-secondary pull-right" onclick="add_komposisi()" >Tambah</button>
            </div>
          </div>
          <table class="table table-vertical-middle">
            <tbody>
              @foreach ($data['komposisi'] as $key => $value)
                <tr>
                  <td style="{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                    <div class="media">
                      <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                        <img src="{{ url('storage/'.$value->gambar) }}" alt="">
                      </div>
                      <div class="media-body align-self-center ">
                        <h6>{{$value->nama_bahan}}</h6>
                        <div>{{$value->jumlah}} {{$value->satuan_komposisi}}</div>
                      </div>
                    </div>
                  </td>
                  <td style="width:1px;white-space:nowrap;{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                    <a href="javascript:;" onclick="edit_komposisi({{$value->id}})" class="button green ripple-effect ico">
                      <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                    </a>
                    <a href="javascript:;" onclick="confirmDelete('komposisi{{$value->id}}')" class="button red ripple-effect ico">
                      <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                    </a>
                    <form action="{{ route('proses_komposisi_menu') }}" method="post" id="hapuskomposisi{{$value->id}}">
                      {{ csrf_field() }}
                      <input type="hidden" name="id" value="{{$value->id}}">
                      <input type="hidden" name="action" value="delete">
                    </form>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>
        <div class="col-md-6">
          <div class="row mg-b-30">
            <div class="col-md-8">
              <h5>Kandungan Nutrisi</h5>
            </div>
            <div class="col-md-4">
              <button class="btn btn-xs btn-secondary pull-right" onclick="add_nutrisi()" >Tambah</button>
            </div>
          </div>
          <div class="row row-sm mg-b-30">
            @foreach ($data['nutrisi'] as $key => $value)
            <div class="col-md-4">
              <div class="card rounded-20 mg-b-20">
                <div class="card-body pd-10 text-center">
                  <h3 class="tx-40 fw-bold">{{ $value->jumlah }}</h3>
                  <h5>{{ $value->nama_nutrisi }}</h5>
                  <p class="text-muted">{{ $value->satuan }}</p>
                  <div class="tx-center">
                    <a href="javascript:;" onclick="edit_nutrisi({{$value->id}})" class="button green ripple-effect ico">
                      <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                    </a>
                    <a href="javascript:;" onclick="confirmDelete('nutrisi{{$value->id}}')" class="button red ripple-effect ico">
                      <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                    </a>
                    <form action="{{ route('proses_nutrisi_menu') }}" method="post" id="hapusnutrisi{{$value->id}}">
                      {{ csrf_field() }}
                      <input type="hidden" name="id" value="{{$value->id}}">
                      <input type="hidden" name="action" value="delete">
                    </form>
                  </div>
                </div>
              </div>
            </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-menu-makanan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_menu_makanan') }}" method="post" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Upload Gambar</label>
              <input type="file" class="dropify" id="gambar" name="gambar">
            </div>
            <div class="form-group">
              <label>Nama Menu Makanan</label>
              <input type="text" class="form-control" id="nama_menu" name="nama_menu" required data-parsley-required-message="Nama Menu Makanan tidak boleh kosong" >
            </div>
            <div class="form-group mg-b-0">
              <label>Deskripsi</label>
              <textarea class="form-control" id="deskripsi" name="deskripsi" style="height:100px"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-komposisi" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_komposisi_menu',['menu_makanan'=>$id]) }}" method="post" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Pilih Bahan Baku</label>
              <select class="select2" style="width:100%" id="bahan_baku" name="bahan_baku">
                @foreach ($data['bahan-baku'] as $key => $value)
                <option value="{{ $value->id }}">{{ $value->nama_bahan }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group">
              <label>Jumlah</label>
              <div class="input-group">
                <input type="text" class="form-control  autonumeric" data-a-dec="," data-a-sep="." id="jumlah" name="jumlah" required data-parsley-required-message="Jumlah Bahan Baku tidak boleh kosong" >
                <div class="input-group-append">
                  <span class="input-group-text" id="satuan_bahan_baku" ></span>
                </div>
              </div>
              <div class="error-message" id="jumlah-error"></div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-nutrisi" role="dialog" >
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_nutrisi_menu',['menu_makanan'=>$id]) }}" method="post" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Pilih Daftar Nutrisi</label>
              <select class="select2" style="width:100%" id="nutrisi" name="nutrisi">
                @foreach ($data['daftar-nutrisi'] as $key => $value)
                <option value="{{ $value->id }}">{{ $value->nama_nutrisi }}</option>
                @endforeach
              </select>
            </div>
            <div class="form-group">
              <label>Jumlah</label>
              <div class="input-group">
                <input type="text" class="form-control  autonumeric" data-a-dec="," data-a-sep="." id="jumlah" name="jumlah" required data-parsley-required-message="Jumlah Kandungan Nutrisi tidak boleh kosong" >
                <div class="input-group-append">
                  <span class="input-group-text" id="satuan" ></span>
                </div>
              </div>
              <div class="error-message" id="jumlah-error"></div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

@endsection
@section('js')
  <script>
  $('#modal-komposisi #jumlah').parsley({
    errorPlacement: function (error, element) {
      if (element.parent().hasClass('input-group')) {
        error.appendTo(element.closest('.form-group').find('.error-message'));
      } else {
        error.insertAfter(element);
      }
    },
    errorsContainer: function (ParsleyField) {
      return ParsleyField.$element.closest('.form-group').find('.error-message');
    }
  });

  $('#modal-nutrisi #jumlah').parsley({
    errorPlacement: function (error, element) {
      if (element.parent().hasClass('input-group')) {
        error.appendTo(element.closest('.form-group').find('.error-message'));
      } else {
        error.insertAfter(element);
      }
    },
    errorsContainer: function (ParsleyField) {
      return ParsleyField.$element.closest('.form-group').find('.error-message');
    }
  });


  function edit_menu_makanan(id){
    $.get("{{ url('api/find_menu_makanan') }}/"+id,function(result){
      $('#modal-menu-makanan #nama_menu').val(result.nama_menu);
      $('#modal-menu-makanan #deskripsi').val(result.deskripsi);
      // $('#modal-menu-makanan #gambar img').attr('src',result.gambar);

      var dropify = $('#modal-menu-makanan #gambar').dropify();
      var dropifyElement = dropify.data('dropify'); // Access dropify instance
      dropifyElement.settings.defaultFile = result.gambar; // Set image URL
      dropifyElement.destroy(); // Destroy current instance
      dropifyElement.init(); // Reinitialize Dropify

      $('#modal-menu-makanan #id').val(id);
      $('#modal-menu-makanan #action').val('edit');
      $('#modal-menu-makanan #title').html('Edit Menu Makanan');
      $('#modal-menu-makanan').modal('show');
    });
  }

  $('#modal-komposisi #bahan_baku').change(function () {
    id =$(this).val();
    $.get("{{ url('api/find_bahan_baku') }}/"+id,function(result){
      $('#modal-komposisi #satuan_bahan_baku').html(result.satuan_komposisi);
    });
  });

  $('#modal-nutrisi #nutrisi').change(function () {
    id =$(this).val();
    $.get("{{ url('api/find_daftar_nutrisi') }}/"+id,function(result){
      $('#modal-nutrisi #satuan').html(result.satuan);
    });
  });

  function add_komposisi(){
    $('#modal-komposisi #bahan_baku').trigger('change');
    $('#modal-komposisi #jumlah').val(0);
    $('#modal-komposisi #id').val(0);
    $('#modal-komposisi #action').val('add');
    $('#modal-komposisi #title').html('Tambah Komposisi Menu Makanan');
    $('#modal-komposisi').modal('show');
  }

  function edit_komposisi(id){
    $.get("{{ url('api/find_komposisi_makanan') }}/"+id,function(result){
      $('#modal-komposisi #bahan_baku').val(result.fid_bahan_baku);
      $('#modal-komposisi #bahan_baku').select2();
      $('#modal-komposisi #jumlah').val(result.jumlah);
      $('#modal-komposisi #bahan_baku').trigger('change');
      $('#modal-komposisi #id').val(id);
      $('#modal-komposisi #action').val('edit');
      $('#modal-komposisi #title').html('Edit Komposisi Menu Makanan');
      $('#modal-komposisi').modal('show');
    });
  }

  function add_nutrisi(){
    $('#modal-nutrisi #nutrisi').trigger('change');
    $('#modal-nutrisi #jumlah').val(0);
    $('#modal-nutrisi #id').val(0);
    $('#modal-nutrisi #action').val('add');
    $('#modal-nutrisi #title').html('Tambah Nutrisi Menu Makanan');
    $('#modal-nutrisi').modal('show');
  }

  function edit_nutrisi(id){
    $.get("{{ url('api/find_nutrisi_makanan') }}/"+id,function(result){
      $('#modal-nutrisi #nutrisi').val(result.fid_nutrisi);
      $('#modal-nutrisi #nutrisi').select2();
      $('#modal-nutrisi #jumlah').val(result.jumlah);
      $('#modal-nutrisi #nutrisi').trigger('change');
      $('#modal-nutrisi #id').val(id);
      $('#modal-nutrisi #action').val('edit');
      $('#modal-nutrisi #title').html('Edit Nutrisi Menu Makanan');
      $('#modal-nutrisi').modal('show');
    });
  }
  </script>
@endsection
