@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" id="search" placeholder="Cari Menu Makanan">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-4">
            <button class="btn btn-primary pull-right" onclick="add_menu_makanan()">Tambah Menu Makanan</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th>Menu Makanan</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['menu-makanan'] as $key => $value)
            <tr>
              <td>{{ $data['menu-makanan']->firstItem() + $key }}</td>
              <td>
                <div class="media">
                  <div class="image-wrapper rounded mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                    <img src="{{(!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )}}" class="rounded" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <h6>{{$value->nama_menu}}</h6>
                    <div class="text-truncated-1 tx-gray-600">{{ (!empty($value->deskripsi) ? $value->deskripsi : 'Tidak ada Deksripsi' ) }}</div>
                  </div>
                </div>
              </td>
              <td style="width:1px;white-space:nowrap;">
                <a href="{{ route('detail_menu_makanan',['id'=>$value->id]) }}" class="button dark ripple-effect ico">
                  <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="edit_menu_makanan({{$value->id}})" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="{{ route('proses_menu_makanan') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['menu-makanan']->links('include.pagination', ['pagination' => $data['menu-makanan']] ) }}</div>
    </div>
  </div>

  <div class="modal fade" id="modal-menu-makanan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_menu_makanan') }}" method="post" enctype="multipart/form-data" data-parsley-validate>
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Upload Gambar</label>
              <input type="file" class="dropify" id="gambar" name="gambar">
            </div>
            <div class="form-group">
              <label>Nama Menu Makanan</label>
              <input type="text" class="form-control" id="nama_menu" name="nama_menu" required data-parsley-required-message="Nama Menu Makanan tidak boleh kosong" >
            </div>
            <div class="form-group mg-b-0">
              <label>Deskripsi</label>
              <textarea class="form-control" id="deskripsi" name="deskripsi" style="height:100px"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@endsection
@section('js')
<script>
function add_menu_makanan(){
  $('#nama_menu').val('');
  $('#deskripsi').val('');
  $('#id').val(0);
  $('#action').val('add');
  $('#title').html('Tambah Menu Makanan');
  $('#modal-menu-makanan').modal('show');
}

function edit_menu_makanan(id){
  $.get("{{ url('api/find_menu_makanan') }}/"+id,function(result){
    $('#nama_menu').val(result.nama_menu);
    $('#deskripsi').val(result.deskripsi);

    var dropify = $('#gambar').dropify();
    var dropifyElement = dropify.data('dropify'); // Access dropify instance
    dropifyElement.settings.defaultFile = result.gambar; // Set image URL
    dropifyElement.destroy(); // Destroy current instance
    dropifyElement.init(); // Reinitialize Dropify

    $('#id').val(id);
    $('#action').val('edit');
    $('#title').html('Edit Menu Makanan');
    $('#modal-menu-makanan').modal('show');
  });
}
</script>
@endsection
