@extends('layouts.dashboard')
@section('css')
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}
#marker {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  background:url('{{ asset('assets/images/location.png') }}') no-repeat top center;
  background-size:100%;
  opacity: 1;
  cursor: move;
  z-index: 9000
}
</style>
@endsection
@section('content')
  <div class="card rounded-20 ht-100p">
    <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
      <h4 class="mg-b-0">Dapur Makanan Bergizi</h4>
    </div>
    <div class="card-body">
      <h6>Status Produksi Makanan Bergizi Hari ini.</h6>
      <h6 class="tx-gray-500 mg-b-30">{{ GlobalHelper::nama_hari(date('Y-m-d')) }}, {{ GlobalHelper::tgl_indo(date('Y-m-d')) }}</h6>
      @if(!empty($data['progres-produksi-makanan']))
        <div class="row row-sm">
          <div class="col-md-6">
            <div class="card rounded-10 mg-b-20 ht-100p">
              <div class="card-body">
                <div class="media mg-b-20 ">
                  <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
                    <img src="{{ url('storage/'.$data['progres-produksi-makanan']->gambar) }}" alt="" class="rounded-10">
                  </div>
                  <div class="media-body align-self-center ">
                    <div class="mg-b-5 tx-15">{{$data['progres-produksi-makanan']->jumlah}} Porsi</div>
                    <h5 class="mg-b-5 tx-20">{{$data['progres-produksi-makanan']->nama_menu}}</h5>
                    @if(!empty($data['progres-produksi-makanan']->status_produksi))
                    <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:{{ $data['progres-produksi-makanan']->color }}"> {{ $data['progres-produksi-makanan']->status_produksi }} </span>
                    @else
                    <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
                    @endif
                  </div>
                </div>
                <h5>Komposisi Makanan</h5>
                <table class="table table-vertical-middle">
                  <tbody>
                    @foreach ($data['progres-produksi-makanan']->komposisi as $key => $value)
                      <tr>
                        <td style="{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                          <div class="media">
                            <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:50px;padding:2px">
                              <img src="{{ url('storage/'.$value->gambar) }}" alt="">
                            </div>
                            <div class="media-body align-self-center ">
                              <h6>{{$value->nama_bahan}}</h6>
                              <div>{{$value->jumlah}} {{$value->satuan}}</div>
                            </div>
                          </div>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="row row-sm">
              @foreach ($data['progres-produksi-makanan']->nutrisi as $key => $value)
              <div class="col-md-3">
                <div class="card rounded-10">
                  <div class="card-body pd-10 text-center">
                    <h3 class="tx-30 mg-b-0">{{ $value->jumlah }}</h3>
                    <h5 class="tx-15 mg-b-0">{{ $value->nama_nutrisi }}</h5>
                    <p class="text-muted">{{ $value->satuan }}</p>
                  </div>
                </div>
              </div>
              @endforeach
            </div>
            <div class="row row-sm mg-t-20">
              <div class="col-md-6">
                <div class="card rounded-10 mg-b-10 bg-gray-100 ht-100p">
                  <div class="card-body tx-center">
                    <h6>Pencucian Alat Makan</h6>
                    <div id="progres_cuci_piring"></div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="card rounded-10 mg-b-10 bg-gray-100 ht-100p">
                  <div class="card-body tx-center">
                    <h6>Pemorsian / Pengepakan</h6>
                    <div id="progres_pengemasan"></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      @endif
    </div>
  </div>
@endsection
@section('js')
  <script src="https://cdn.jsdelivr.net/npm/ol@v9.0.0/dist/ol.js"></script>
  <script src="{{asset('assets/lib/apexcharts/apexcharts.min.js')}}"></script>
  <script>
  @if(!empty($data['progres-produksi-makanan']))
  get_chart_progres_cuci_piring({{ GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['persentase'] }});
  function get_chart_progres_cuci_piring(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_cuci_piring"), options);
    chart.render();
  }

  get_chart_progres_pengemasan({{ GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['persentase'] }});
  function get_chart_progres_pengemasan(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_pengemasan"), options);
    chart.render();
  }
  @endif
  </script>
@endsection
