@extends('layouts.main')
@section('css')
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}

</style>
@endsection
@section('content')
<div class="row row-sm">
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Pasokan Bahan Baku Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="{{ route('dashboard',['submenu'=>'bahan_baku']) }}">Lihat Semua</a>
      </div>
      <div class="card-body">
        <div class="d-flex ht-100p">
          <div class="flex-fill">
            <div class="mg-b-20" id="pie_stok_bahan_baku"></div>
            <ul class="list-inline justify-content-center d-flex mg-b-20">
              <li class="list-inline-item d-flex align-items-center">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#16a085"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Cukup</span>
              </li>
              <li class="list-inline-item d-flex align-items-center mg-l-10">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#f39c12"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Rendah</span>
              </li>
              <li class="list-inline-item d-flex align-items-center mg-l-10">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#c0392b"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Kritis</span>
              </li>
            </ul>
            @foreach ($data['bahan-baku'] as $key => $value)
            <div class="card rounded-10 mg-b-10">
              <div class="card-body pd-10">
                <div class="media">
                  <div class="image-wrapper rounded-10 mg-r-10 " style="aspect-ratio:1/1;width:50px;">
                    <img class="rounded-10" src="{{(!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )}}" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <p class="tx-medium mg-b-0">{{$value->nama_bahan}}</p>
                    <small class="tx-11 tx-gray-500 mg-b-0">{{$value->nama_kategori}}</small>
                  </div>
                </div>
              </div>
              <div class="card-footer pd-0">
                <div class="pd-x-10 pd-t-10">
                  <div class="d-flex">
                    <div class="flex-grow-1">
                      <span class="tx-11 tx-white rounded pd-x-8 pd-y-3" style="background:{{$value->color}}">{{$value->status}}</span>
                    </div>
                    <a href="{{ route('detail_bahan_baku',['id'=>$value->id,'tab'=>'pembelian','mode'=>'order']) }}" class="align-self-center link-03 tx-12">Pesan Sekarang <i class="icon ion-md-arrow-forward mg-l-5"></i></a>
                  </div>
                </div>
                <hr style="margin-top: 0.7rem;margin-bottom: 0px;">
                <div class="pd-10">
                  <div class="d-flex">
                    <div class="wd-50p">
                      <div class="tx-11 tx-gray-700">Sisa Stok</div>
                      <h6 class="tx-12">{{$value->stok}} {{$value->satuan}}</h6>
                    </div>
                    <div class="wd-50p">
                      <div class="tx-11 tx-gray-700">Kekurangan Stok</div>
                      <h6 class="tx-12">{{$value->kekurangan_stok}} {{$value->satuan}}</h6>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            @endforeach
          </div>
          <div class="divider-text divider-vertical" data-text="and"></div>
          <div class="flex-fill">
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="{{ asset('assets/images/bahan-baku-2.png') }}" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5">{{ GlobalHelper::jumlah_bahan_baku('all') }}</h6>
                <div class="tx-gray-600">Total Bahan Baku</div>
              </div>
            </div>
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="{{ asset('assets/images/supplier.png') }}" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5">{{$data['jumlah-supplier']}}</h6>
                <div class="tx-gray-600">Total Supplier</div>
              </div>
            </div>
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="{{ asset('assets/images/order.png') }}" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5">40</h6>
                <div class="tx-gray-600">Total Pesanan Berlangsung</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Dapur Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="{{ route('dashboard',['submenu'=>'dapur']) }}">Lihat Semua</a>
      </div>
      <div class="card-body">
        <h6>Status Produksi Makanan Bergizi Hari ini.</h6>
        <h6 class="tx-gray-500 mg-b-30">{{ GlobalHelper::nama_hari(date('Y-m-d')) }}, {{ GlobalHelper::tgl_indo(date('Y-m-d')) }}</h6>
        @if(!empty($data['progres-produksi-makanan']))
          <div class="media mg-b-20 ">
            <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
              <img src="{{ url('storage/'.$data['progres-produksi-makanan']->gambar) }}" alt="" class="rounded-10">
            </div>
            <div class="media-body align-self-center ">
              <div class="mg-b-5 tx-15">{{$data['progres-produksi-makanan']->jumlah}} Porsi</div>
              <h5 class="mg-b-5 tx-20">{{$data['progres-produksi-makanan']->nama_menu}}</h5>
              @if(!empty($data['progres-produksi-makanan']->status_produksi))
              <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:{{ $data['progres-produksi-makanan']->color }}"> {{ $data['progres-produksi-makanan']->status_produksi }} </span>
              @else
              <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
              @endif
            </div>
          </div>
          <div class="card rounded-10 mg-b-10">
            <div class="card-body">
              <h5>Komposisi Makanan</h5>
              <table class="table table-vertical-middle">
                <tbody>
                  @foreach ($data['progres-produksi-makanan']->komposisi as $key => $value)
                    <tr>
                      <td style="{{ ($key == 0 ? 'border-top:0 !important' : null ) }}">
                        <div class="media">
                          <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:50px;padding:2px">
                            <img src="{{ url('storage/'.$value->gambar) }}" alt="">
                          </div>
                          <div class="media-body align-self-center ">
                            <h6>{{$value->nama_bahan}}</h6>
                            <div>{{$value->jumlah}} {{$value->satuan}}</div>
                          </div>
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
          <div class="row row-xs">
            @foreach ($data['progres-produksi-makanan']->nutrisi as $key => $value)
            <div class="col-md-3">
              <div class="card rounded-10">
                <div class="card-body pd-10 text-center">
                  <h3 class="tx-30 mg-b-0">{{ $value->jumlah }}</h3>
                  <h5 class="tx-15 mg-b-0">{{ $value->nama_nutrisi }}</h5>
                  <p class="text-muted">{{ $value->satuan }}</p>
                </div>
              </div>
            </div>
            @endforeach
          </div>
          <div class="row row-xs mg-t-10">
            <div class="col-md-6">
              <div class="card rounded-10 mg-b-10 bg-gray-100">
                <div class="card-body tx-center">
                  <h6>Pencucian Alat Makan</h6>
                  <div id="progres_cuci_piring"></div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card rounded-10 mg-b-10 bg-gray-100">
                <div class="card-body tx-center">
                  <h6>Pemorsian / Pengepakan</h6>
                  <div id="progres_pengemasan"></div>
                </div>
              </div>
            </div>
          </div>
        @endif
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Distribusi Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="{{ route('dashboard',['submenu'=>'distribusi']) }}">Lihat Semua</a>
      </div>
      <div class="card-body pd-10">
        <div id="map" class="rounded-20 bg-gray-500 ht-100p" style="width:100%;aspect-ratio:1/1"></div>
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Penerima Manfaat Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="{{ route('dashboard',['submenu'=>'penerima_manfaat']) }}">Lihat Semua</a>
      </div>
      <div class="card-body">
        <div class="row row-xs">
          <div class="col-md-6">
            <div class="card rounded-10">
              <div class="card-body">
                <div class="media">
                  <img src="{{ asset('assets/images/school.png') }}" class="mg-r-10" style="width:60px">
                  <div class="media-body align-self-center ">
                    <h6 class="tx-20 mb-0">{{ $data['jumlah-sekolah'] }}</h6>
                    <div class="tx-gray-600">Total Sekolah</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card rounded-10">
              <div class="card-body">
                <div class="media">
                  <img src="{{ asset('assets/images/students.png') }}" class="mg-r-10" style="width:60px">
                  <div class="media-body align-self-center ">
                    <h6 class="tx-20 mb-0">{{ $data['jumlah-siswa'] }}</h6>
                    <div class="tx-gray-600">Total Peserta Didik</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="card mg-t-20 rounded-10">
          <div class="card-body">
            <div class="" id="pie_jumlah_siswa"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="card ht-100p rounded-20">
  <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
    <h6 class="mg-b-0">CCTV Dapur Makanan Bergizi</h6>
    <a class="btn btn-sm btn-primary" target="_blank" href="{{ route('dashboard',['submenu'=>'cctv_dapur']) }}">Lihat Semua</a>
  </div>
  <div class="card-body">
    <div class="row row-sm">
      @for ($i=0; $i < 6; $i++)
        <div class="col-md-4">
          <div class="image-wrapper bg-gray-500 rounded-20 mg-b-20" style="aspect-ratio:4/3">
            <img class="rounded-10" src="{{ asset('assets/images/cctv-offline.jpg') }}" alt="">
          </div>
        </div>
      @endfor
    </div>
  </div>
</div>
@endsection
@section('js')
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDymbs_1T1obAHoub1_27J5sj-cG_q0pIs"></script>
  <script src="{{asset('assets/lib/apexcharts/apexcharts.min.js')}}"></script>
  <script>
  $(document).ready(function () {
      let dapur = { lat: -7.427628551783064, lng: 112.70805805303137 };
      @foreach ($data['penerima-manfaat'] as $key => $value)
      let sekolah{{$value->id}} = { lat: {{$value->latitude}}, lng: {{$value->longitude}} };
      @endforeach

      const mapOptions = {
          center: dapur,
          zoom: 10,
      };

      const map = new google.maps.Map(document.getElementById('map'), mapOptions);

      @foreach ($data['penerima-manfaat'] as $key => $value)
        const directionsService{{$value->id}} = new google.maps.DirectionsService();
        const directionsRenderer{{$value->id}} = new google.maps.DirectionsRenderer({
            map: map,
            polylineOptions: {
                strokeColor: "{{$value->color}}",
                strokeOpacity: 0.5,
                strokeWeight: 7
            }
        });
        const request{{$value->id}} = {
            origin: dapur,
            destination: sekolah{{$value->id}},
            travelMode: google.maps.TravelMode.DRIVING,
        };
        directionsService{{$value->id}}.route(request{{$value->id}}, function (result, status) {
          if (status === google.maps.DirectionsStatus.OK) {
              directionsRenderer{{$value->id}}.setDirections(result);

              const route = result.routes[0].legs[0];
              const distance = route.distance.text;
              const duration = route.duration.text;

              const info = `Distance: ${distance}, Estimated Time: ${duration}`;
          } else {
              console.error("Directions request failed due to " + status);
          }
        });
      @endforeach
  });


  get_pie_stok_bahan_baku({{ GlobalHelper::jumlah_bahan_baku('normal') }},{{ GlobalHelper::jumlah_bahan_baku('rendah') }},{{ GlobalHelper::jumlah_bahan_baku('kritis') }});
  function get_pie_stok_bahan_baku(cukup,rendah,kritis){
    var options = {
      series: [cukup,rendah,kritis],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 1,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Cukup", "Rendah", "Kritis"],
  		colors: ["#16a085","#f39c12","#c0392b"]
    };
    var chart = new ApexCharts(document.querySelector("#pie_stok_bahan_baku"), options);
    chart.render();
  }

  get_pie_jumlah_siswa({{$data['jumlah-laki-laki']}},{{ $data['jumlah-perempuan'] }});
  function get_pie_jumlah_siswa(laki_laki,perempuan){
    var options = {
      series: [laki_laki,perempuan],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 0.8,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Laki-Laki", "Perempuan"],
  		colors: ["#2d98da","#ef5777"],
      legend: {
        show: true,
        position: 'bottom'
      }
    };
    var chart = new ApexCharts(document.querySelector("#pie_jumlah_siswa"), options);
    chart.render();
  }

  @if(!empty($data['progres-produksi-makanan']))
  get_chart_progres_cuci_piring({{ GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['persentase'] }});
  function get_chart_progres_cuci_piring(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_cuci_piring"), options);
    chart.render();
  }

  get_chart_progres_pengemasan({{ GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['persentase'] }});
  function get_chart_progres_pengemasan(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["{{ GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['color'] }}"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_pengemasan"), options);
    chart.render();
  }
  @endif
  </script>
@endsection
