<table class="table table-vertical-middle">
  <thead>
    <tr>
      <th width="50px">No</th>
      <th class="tx-center">Tanggal</th>
      <th class="tx-center">Jumlah</th>
      <th>Kanal Pembelian</th>
      <th>Pemasok</th>
      <th>Harga Beli</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    @foreach ($data['bahan-baku']->pembelian as $key => $value)
      <tr>
        <td>{{ $data['bahan-baku']->pembelian->firstItem() + $key }}</td>
        <td class="tx-center">{{ GlobalHelper::dateFormat($value->tanggal,'d/m/Y') }}</td>
        <td class="tx-center">{{ $value->jumlah }} {{ $data['bahan-baku']->satuan }}</td>
        <td>{{ $value->kanal_pembelian }}</td>
        <td>{{ $value->nama_pemasok }}</td>
        <td>Rp {{ number_format($value->harga_beli,0,',','.') }}</td>
        <td style="width:1px;white-space:nowrap;">
          <a href="javascript:;" onclick="edit_pembelian_bahan_baku({{$value->id}})" class="button green ripple-effect ico">
            <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
          </a>
          <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
            <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
          </a>
          <form action="{{ route('proses_pembelian_bahan_baku') }}" method="post" id="hapus{{$value->id}}">
            {{ csrf_field() }}
            <input type="hidden" name="id" value="{{$value->id}}">
            <input type="hidden" name="action" value="delete">
          </form>
        </td>
      </tr>
    @endforeach
  </tbody>
</table>
<div class="pd-x-30 pd-y-20">{{ $data['bahan-baku']->pembelian->links('include.pagination', ['pagination' => $data['bahan-baku']->pembelian] ) }}</div>
