@extends('layouts.main')
@section('content')
  <div class="row row-sm mg-b-20">
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="{{ asset('assets/images/bahan-baku.png') }}" class="mg-r-5" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0">{{ GlobalHelper::jumlah_bahan_baku('all') }}</h6>
              <div class="tx-gray-600">Total Bahan Baku</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="{{ asset('assets/images/stok-normal.png') }}" class="mg-r-5" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0">{{ GlobalHelper::jumlah_bahan_baku('normal') }}</h6>
              <div class="tx-gray-600">Stok Cukup</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="{{ asset('assets/images/stok-rendah.png') }}" class="mg-r-5" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0">{{ GlobalHelper::jumlah_bahan_baku('rendah') }}</h6>
              <div class="tx-gray-600">Stok Rendah</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="{{ asset('assets/images/stok-kritis.png') }}" class="mg-r-5" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0">{{ GlobalHelper::jumlah_bahan_baku('kritis') }}</h6>
              <div class="tx-gray-600">Stok Kritis</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-2">
            <form action="" method="get">
              <select class="select2" name="kategori" style="width:100%" onchange="javascript:submit()">
                <option value="all" {{ ($kategori == 'all' ? 'selected' : null ) }}>Semua Kategori</option>
                @foreach ($data['kategori'] as $key => $value)
                  <option value="{{ $value->id }}" {{ ($kategori == $value->id ? 'selected' : null ) }} >{{ $value->nama_kategori }}</option>
                @endforeach
              </select>
              <input type="hidden" name="status" value="{{ $status }}">
            </form>
          </div>
          <div class="col-md-2">
            <form action="" method="get">
              <input type="hidden" name="kategori" value="{{ $kategori }}">
              <select class="select2" name="status" style="width:100%" onchange="javascript:submit()">
                <option value="all" {{ ($status == 'all' ? 'selected' : null ) }} >Semua Status</option>
                @foreach ($data['status'] as $label => $value)
                  <option value="{{ $label }}" {{ ($status == $label ? 'selected' : null ) }} >{{ $value }}</option>
                @endforeach
              </select>
            </form>
          </div>
          <div class="col-md-5">
            <form action="" method="get">
              <input type="hidden" name="kategori" value="{{ $kategori }}">
              <input type="hidden" name="status" value="{{ $status }}">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" name="search" value="{{ $search }}" placeholder="Cari Bahan Baku">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-3">
            <button class="btn btn-primary pull-right" onclick="add_bahan_baku()">Tambah Bahan Baku</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th>Nama Produk</th>
            <th class="tx-center">Stok Tersedia</th>
            <th class="tx-center">Satuan</th>
            <th class="tx-right">Harga Beli</th>
            <th class="tx-center">Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['bahan-baku'] as $key => $value)
            <tr>
              <td>{{ $data['bahan-baku']->firstItem() + $key }}</td>
              <td>
                <div class="media">
                  <div class="image-wrapper rounded mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                    <img class="rounded" src="{{(!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )}}" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <h6>{{$value->nama_bahan}}</h6>
                    <div>{{$value->nama_kategori}}</div>
                  </div>
                </div>
              </td>
              <td class="tx-center">{{number_format($value->stok,0,',','.')}}</td>
              <td class="tx-center">{{$value->satuan}}</td>
              <td class="tx-right">Rp {{number_format($value->harga_beli,0,',','.')}}</td>
              <td class="tx-center" style="color:{{$value->color}}">{{$value->status}}</td>
              <td style="width:1px;white-space:nowrap;">
                <a href="{{ route('detail_bahan_baku',['id'=>$value->id]) }}" class="button dark ripple-effect ico">
                  <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="edit_bahan_baku({{$value->id}})" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="{{ route('proses_bahan_baku') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['bahan-baku']->links('include.pagination', ['pagination' => $data['bahan-baku']] ) }}</div>
    </div>
  </div>

  <div class="modal fade" id="modal-bahan-baku" role="dialog">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_bahan_baku') }}" method="post" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="row">
              <div class="col-md-7">
                <div class="form-group">
                  <label>Nama Bahan Baku</label>
                  <input type="text" class="form-control" id="nama_bahan" name="nama_bahan" required data-parsley-required-message="Nama Bahan Baku tidak boleh kosong" >
                </div>
                <div class="row row-xs">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Kategori</label>
                      <select class="select2" style="width:100%" id="kategori" name="kategori">
                        @foreach ($data['kategori'] as $key => $value)
                        <option value="{{ $value->id }}">{{ $value->nama_kategori }}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Satuan</label>
                      <select class="select2" style="width:100%" id="satuan" name="satuan">
                        @foreach ($data['satuan'] as $key => $value)
                        <option value="{{ $value->id }}">{{ $value->satuan }}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Deskripsi</label>
                  <textarea class="form-control" id="deskripsi" name="deskripsi"></textarea>
                </div>
                <div class="row row-xs">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Maksimum</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_maksimum" name="stok_maksimum" required  data-parsley-required-message="Stok Maksimum tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Rendah</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_rendah" name="stok_rendah" required data-parsley-required-message="Stok Rendah tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Kritis</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_kritis" name="stok_kritis" required data-parsley-required-message="Stok Kritis tidak boleh kosong">
                    </div>
                  </div>
                </div>
                <div class="row row-xs">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Awal</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_awal" name="stok_awal" required data-parsley-required-message="Stok Awal tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-8">
                    <div class="form-group">
                      <label>Harga Beli</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="harga_beli" name="harga_beli" required data-parsley-required-message="Harga Beli tidak boleh kosong">
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <label>Upload Gambar</label>
                  <input type="file" class="dropify" id="gambar" name="gambar" data-default-file="">
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@endsection
@section('js')
<script>
function add_bahan_baku(){
  $('#nama_bahan').val('');
  $('#stok_maksimum').val('');
  $('#stok_rendah').val('');
  $('#stok_kritis').val('');
  $('#stok_awal').val('');
  $('#harga_beli').val(0);
  $('#deskripsi').val('');
  $('#gambar img').attr('src','{{asset('assets/images/image-default.jpg')}}');
  $('#id').val(0);
  $('#action').val('add');
  $('#title').html('Tambah Bahan Baku');
  $('#modal-bahan-baku').modal('show');
}

function edit_bahan_baku(id){
  $.get("{{ url('api/find_bahan_baku') }}/"+id,function(result){
    $('#nama_bahan').val(result.nama_bahan);
    $('#stok_maksimum').val(result.stok_maksimum);
    $('#stok_rendah').val(result.stok_rendah);
    $('#stok_kritis').val(result.stok_kritis);
    $('#stok_awal').val(result.stok_awal);
    $('#harga_beli').val(result.harga_beli);
    $('#deskripsi').val(result.deskripsi);

    // $('#gambar').attr('data-default-file',result.gambar);
    var dropify = $('#gambar').dropify();
    var dropifyElement = dropify.data('dropify'); // Access dropify instance
    dropifyElement.settings.defaultFile = result.gambar; // Set image URL
    dropifyElement.destroy(); // Destroy current instance
    dropifyElement.init(); // Reinitialize Dropify

    $('#satuan').val(result.fid_satuan);
    $('#satuan').select2();

    $('#kategori').val(result.fid_kategori);
    $('#kategori').select2();

    $('#id').val(id);
    $('#action').val('edit');
    $('#title').html('Edit Bahan Baku');
    $('#modal-bahan-baku').modal('show');
  });
}
</script>
@endsection
