@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row">
          <div class="col-md-4">
            <form action="">
              <select class="select2" name="hak_akses" style="width:100%" onchange="javascript:submit()">
                @foreach ($data['hak_akses'] as $key => $value)
                  <option value="{{$value->id}}" {{($hak_akses==$value->id ? 'selected' : '')}} >{{$value->hak_akses}}</option>
                @endforeach
              </select>
            </form>
          </div>
        </div>
      </div>
      <form action="{{ route('proses_otoritas_modul') }}" method="POST">
        <table class="table">
          <thead>
            <tr>
              <th width="30px">No</th>
              <th colspan="2">Nama Modul</th>
              <th style="width:80px;text-align:center;line-height:25px">View<br><input type="checkbox" id="check_all_view"></th>
              <th style="width:80px;text-align:center;line-height:25px">Insert<br><input type="checkbox" id="check_all_insert"></th>
              <th style="width:80px;text-align:center;line-height:25px">Update<br><input type="checkbox" id="check_all_update"></th>
              <th style="width:80px;text-align:center;line-height:25px">Delete<br><input type="checkbox" id="check_all_delete"></th>
            </tr>
          </thead>
          <tbody>
            @foreach ($data['modul'] as $key => $value)
              @php($otoritas=$value->otoritas)
              <tr style="background:whitesmoke">
                <td style="text-align:left">{{$key+1}}</td>
                <td style="text-align:left" colspan="2">{{$value->nama_modul}}<input type="hidden" name="id[]" value="{{$value->id}}" ></td>
                <td style="text-align:center"><input type="checkbox" @if($otoritas['view'] == 'Y') checked @endif class="checkbox_view" name="view[{{$value->id}}]" value="Y" ></td>
                <td style="text-align:center"><input type="checkbox" @if($otoritas['insert'] == 'Y') checked @endif class="checkbox_insert" name="insert[{{$value->id}}]" value="Y" ></td>
                <td style="text-align:center"><input type="checkbox" @if($otoritas['update'] == 'Y') checked @endif class="checkbox_update" name="update[{{$value->id}}]" value="Y" ></td>
                <td style="text-align:center"><input type="checkbox" @if($otoritas['delete'] == 'Y') checked @endif class="checkbox_delete" name="delete[{{$value->id}}]" value="Y" ></td>
              </tr>
              @foreach ($value->submodul as $key2 => $value2)
                @php($otoritas=$value2->otoritas)
                <tr>
                  <td style="text-align:left">{{$key+1}}.{{$key2+1}}</td>
                  <td style="text-align:left" colspan="2">{{$value2->nama_modul}}<input type="hidden" name="id[]" value="{{$value2->id}}" ></td>
                  <td style="text-align:center"><input type="checkbox" @if($otoritas['view'] == 'Y') checked @endif class="checkbox_view" name="view[{{$value2->id}}]" value="Y" ></td>
                  <td style="text-align:center"><input type="checkbox" @if($otoritas['insert'] == 'Y') checked @endif class="checkbox_insert" name="insert[{{$value2->id}}]" value="Y" ></td>
                  <td style="text-align:center"><input type="checkbox" @if($otoritas['update'] == 'Y') checked @endif class="checkbox_update" name="update[{{$value2->id}}]" value="Y" ></td>
                  <td style="text-align:center"><input type="checkbox" @if($otoritas['delete'] == 'Y') checked @endif class="checkbox_delete" name="delete[{{$value2->id}}]" value="Y" ></td>
                </tr>
              @endforeach
            @endforeach
          </tbody>
        </table>
        <div style="padding:20px">
          {{ csrf_field() }}
          <input type="hidden" name="hak_akses" value="{{$hak_akses}}">
    			<button type="submit" class="btn btn-block btn-primary" >SIMPAN</button>
        </div>
		  </form>
    </div>
  </div>
@endsection
@section('js')
<script>
$("#check_all_view").click(function(){
  $('.checkbox_view').not(this).prop('checked', this.checked);
});
$("#check_all_insert").click(function(){
  $('.checkbox_insert').not(this).prop('checked', this.checked);
});
$("#check_all_update").click(function(){
  $('.checkbox_update').not(this).prop('checked', this.checked);
});
$("#check_all_delete").click(function(){
  $('.checkbox_delete').not(this).prop('checked', this.checked);
});
</script>
@endsection
