@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-xs">
          <div class="col-md-10">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" name="search" value="{{$search}}" placeholder="Search">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-2">
            <button type="button" class="btn btn-block btn-dark" onclick="add_user()" >Tambah User</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead>
          <tr>
            <th width="50">No</th>
            <th>Nama User</th>
            <th>Hak Akses</th>
            <th>Email</th>
            <th>No Handphone</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['user'] as $key => $value)
            <tr>
              <td>{{$data['user']->firstItem() + $key}}</td>
              <td>
                <div class="media">
                  <div class="image-wrapper rounded mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                    <img src="{{(!empty($value->foto) ? asset('storage/'.$value->foto) : asset('assets/images/user-avatar-placeholder.png') )}}" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <h6>{{$value->nama_lengkap}}</h6>
                    <div>{{$value->username}}</div>
                  </div>
                </div>
              </td>
              <td>{{$value->hak_akses}}</td>
              <td>{{ (!empty($value->email) ? $value->email : '---') }}</td>
              <td>{{ (!empty($value->no_handphone) ? $value->no_handphone : '---') }}</td>
              <td style="width:1px;white-space:nowrap;">
                <a href="javascript:;" onclick="edit_user('{{$value->id}}')" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="{{ route('proses_user') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['user']->links('include.pagination', ['pagination' => $data['user']] ) }}</div>
    </div>
  </div>

  <div class="modal fade" role="dialog" id="modal-user">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_user') }}" method="POST" enctype="multipart/form-data" data-parsley-validate >
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="row">
              <div class="col-auto">
                <div class="form-group">
                  <label>Upload Foto</label>
                  <div class="image-wrapper" id="foto" data-tippy-placement="bottom" style="width:150px;height:150px;padding:5px" title="Change Image">
                    <img src="" alt="" />
                    <div class="upload-button" onclick="changeImage('foto')"></div>
                    <input class="file-upload" type="file" name="foto" accept="image/*"/>
                  </div>
                </div>
              </div>
              <div class="col">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>NIK</label>
                      <input type="text numeric" class="form-control" name="nik" id="nik" required data-parsley-required-message="NIK tidak boleh kosong" >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Nama Lengkap</label>
                      <input type="text" class="form-control" name="nama_lengkap" id="nama_lengkap" required data-parsley-required-message="Nama Lengkap tidak boleh kosong" >
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Username</label>
                      <input type="text" class="form-control" name="username" id="username" required data-parsley-required-message="Username tidak boleh kosong" >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Password</label>
                      <input type="text" class="form-control" id="password" name="password" required data-parsley-required-message="Password tidak boleh kosong" >
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Hak Akses</label>
                  <select class="select2" id="hak_akses" name="hak_akses" style="width:100%">
                    @foreach ($data['hak_akses'] as $key => $value)
                    <option value="{{$value->id}}">{{$value->hak_akses}}</option>
                    @endforeach
                  </select>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Email</label>
                      <input type="email" class="form-control" name="email" id="email" required data-parsley-required-message="Email tidak boleh kosong" data-parsley-type="email" data-parsley-type-message="Masukkan email yang valid, contoh: user@example.com." >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>No. Handphone</label>
                      <input type="text" class="form-control numeric" name="no_handphone" id="no_handphone" required data-parsley-required-message="No. Handphone tidak boleh kosong" >
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Alamat</label>
                  <input type="text" class="form-control" id="alamat" name="alamat" required data-parsley-required-message="Alamat tidak boleh kosong" >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" id="id" name="id">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kembali</button>
            <button type="submit" class="btn btn-primary" id="action" name="action" value="add">Tambahkan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@endsection
@section('js')
<script>
  function add_user(){
    $('#nik').val('');
    $('#nama_lengkap').val('');
    $('#username').val('');
    $('#no_handphone').val('');
    $('#email').val('');
    $('#alamat').val('');
    $('#foto img').attr('src','{{asset('assets/images/user-avatar-placeholder.png')}}');
    $('#id').val(0);
    $('#title').html('Tambah User');
    $('#action').val('add');
    $('#action').html('Tambahkan');
    $('#modal-user').modal('show');
  }

  function edit_user(id){
    $.get("{{ url('api/find_user') }}/"+id,function(result){
      $('#nik').val(result.nik);
      $('#nama_lengkap').val(result.nama_lengkap);
      $('#username').val(result.username);
      $('#no_handphone').val(result.no_handphone);
      $('#email').val(result.email);
      $('#hak_akses').val(result.fid_hak_akses);
      $('#hak_akses').select2();
      $('#alamat').val(result.alamat);
      $('#foto img').attr('src',result.foto);
      $('#id').val(id);
      $('#title').html('Edit User');
      $('#action').val('edit');
      $('#action').html('Simpan');
      $('#modal-user').modal('show');
    });
  }
</script>
@endsection
