@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-xs">
          <div class="col-md-10">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" name="search" value="{{$search}}" placeholder="Search">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-2">
            <button type="button" class="btn btn-block btn-dark" onclick="add_kategori()" >Tambah Kategori</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead>
          <tr>
            <th width="50">No</th>
            <th width="250px">Nama Kategori</th>
            <th>Keterangan</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['kategori'] as $key => $value)
            <tr>
              <td>{{$data['kategori']->firstItem() + $key}}</td>
              <td>{{$value->nama_kategori}}</td>
              <td>{!! (!empty($value->keterangan) ? $value->keterangan : '<span class="tx-gray-500">Tidak ada Keterangan</span>' ) !!}</td>
              <td style="width:1px;white-space:nowrap;">
                <a href="javascript:;" onclick="edit_kategori('{{$value->id}}')" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="{{ route('proses_kategori_bahan_baku') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['kategori']->links('include.pagination', ['pagination' => $data['kategori']] ) }}</div>
    </div>
  </div>

  <div class="modal fade" role="dialog" id="modal-kategori">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="{{ route('proses_kategori_bahan_baku') }}" method="POST" enctype="multipart/form-data" data-parsley-validate>
          {{ csrf_field() }}
          <div class="modal-body">
            <div class="form-group">
              <label>Nama Kategori</label>
              <input type="text" class="form-control" name="nama_kategori" id="nama_kategori" required data-parsley-required-message="Nama Kategori tidak boleh kosong" >
            </div>
            <div class="form-group">
              <label>Keterangan</label>
              <textarea class="form-control" name="keterangan" id="keterangan" ></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" id="id" name="id">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kembali</button>
            <button type="submit" class="btn btn-primary" id="action" name="action" value="add">Tambahkan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
@endsection
@section('js')
<script>
  function add_kategori(){
    $('#nama_kategori').val('');
    $('#keterangan').val('');
    $('#id').val(0);
    $('#title').html('Tambah Kategori Bahan Baku');
    $('#action').val('add');
    $('#action').html('Tambahkan');
    $('#modal-kategori').modal('show');
  }

  function edit_kategori(id){
    $.get("{{ url('api/find_kategori_bahan_baku') }}/"+id,function(result){
      $('#nama_kategori').val(result.nama_kategori);
      $('#keterangan').val(result.keterangan);
      $('#id').val(id);
      $('#title').html('Tambah Kategori Bahan Baku');
      $('#action').val('edit');
      $('#action').html('Simpan');
      $('#modal-kategori').modal('show');
    });
  }
</script>
@endsection
