@extends('layouts.main')
@section('css')
  <style>
  .rounded-20 .card-header:first-child{
    border-radius: 20px 20px 0 0;
  }

  </style>
@endsection
@section('content')
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:5px">
      <img src="{{(!empty($data['penerima-manfaat']->logo) ? asset('storage/'.$data['penerima-manfaat']->logo) : asset('assets/images/image-default.jpg') )}}" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <h5 class="mb-0">{{$data['penerima-manfaat']->nama_sekolah}}</h5>
      <div class="mg-b-10">NPSN. {{$data['penerima-manfaat']->npsn}}</div>
      <a class="btn btn-xs btn-primary" href="{{ route('form_penerima_manfaat',['id'=>$data['penerima-manfaat']->id]) }}" >Edit Sekolah</a>
      {{-- <button class="btn btn-xs btn-success" onclick="add_pembelian_bahan_baku()" >Beli Bahan Baku</button> --}}
    </div>
  </div>
  <div class="card card-table rounded-20" style="min-height: calc(100vh - 275px )">
    <div class="card-header">
      <ul class="nav nav-pills">
        <li class="nav-item">
          <a class="nav-link {{($tab == 'informasi' ? 'active' : null )}}" href="{{ route('detail_penerima_manfaat',['id'=>$data['penerima-manfaat']->id,'tab'=>'informasi']) }}">Informasi Sekolah</a>
        </li>
        <li class="nav-item">
          <a class="nav-link {{($tab == 'alamat_kontak' ? 'active' : null )}}" href="{{ route('detail_penerima_manfaat',['id'=>$data['penerima-manfaat']->id,'tab'=>'alamat_kontak']) }}">Alamat dan Kontak</a>
        </li>
        <li class="nav-item">
          <a class="nav-link {{($tab == 'peserta_didik' ? 'active' : null )}}" href="{{ route('detail_penerima_manfaat',['id'=>$data['penerima-manfaat']->id,'tab'=>'peserta_didik']) }}">Peserta Didik</a>
        </li>
      </ul>
    </div>
    <div class="card-body">
      @include('penerima_manfaat.detail.'.$tab)
    </div>
  </div>
@endsection
