@extends('layouts.main')
@section('content')
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" name="search" value="{{ $search }}" placeholder="Cari Data Pengiriman Makanan">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th>Waktu</th>
            <th>Menu Makanan</th>
            <th>Tujuan Sekolah</th>
            <th>Nama Pengemudi</th>
            <th class="tx-center">Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          @foreach ($data['pengiriman-makanan'] as $key => $value)
            <tr>
              <td>{{ $data['pengiriman-makanan']->firstItem() + $key }}</td>
              <td>{{ GlobalHelper::dateFormat($value->tanggal,'d-m-Y') }}<br>{{ GlobalHelper::dateFormat($value->created_at,'H:i') }} WIB</td>
              <td>
                <h6>{{$value->nama_menu}}</h6>
                <div class="text-truncated-1">{{$value->jumlah}} Porsi</div>
              </td>
              <td>
                <h6>{{$value->nama_sekolah}}</h6>
                <div>{!! (!empty($value->alamat) ? $value->alamat : '---' ) !!}, RT {{ $value->rt }} / RW {{ $value->rw }}</div>
              </td>
              <td>
                <h6>{{$value->nama_lengkap}}</h6>
              </td>
              <td class="tx-center">{{ $value->status }}</td>
              <td style="width:1px;white-space:nowrap;">
                <a href="{{ route('detail_pengiriman',['id'=>$value->id]) }}" class="button dark ripple-effect ico">
                  <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete({{$value->id}})" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="{{ route('proses_penerima_manfaat') }}" method="post" id="hapus{{$value->id}}">
                  {{ csrf_field() }}
                  <input type="hidden" name="id" value="{{$value->id}}">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20">{{ $data['pengiriman-makanan']->links('include.pagination', ['pagination' => $data['pengiriman-makanan']] ) }}</div>
    </div>
  </div>
@endsection
@section('js')
<script>

</script>
@endsection
