<?php
Route::get('storage/{folder}/{filename}', function ($folder,$filename){
  $path = storage_path('app/' . $folder . '/' . $filename);
  if (!File::exists($path)) {
      abort(404);
  }
  $file = File::get($path);
  $type = File::mimeType($path);
  $response = Response::make($file, 200);
  $response->header("Content-Type", $type);
  return $response;
});

Route::post('image/upload',[App\Http\Controllers\MasterController::class, 'upload_image'])->name("upload_image");
Route::post('ckeditor/image/upload',[App\Http\Controllers\MasterController::class, 'ckeditor_upload_image'])->name("ckeditor_upload_image");

Route::get('auth/login',[App\Http\Controllers\AuthController::class, 'login'])->name('login');
Route::post('auth/login/proses',[App\Http\Controllers\AuthController::class, 'proses_login'])->name('proses_login');

Route::group(['middleware' => ['ceklogin']],function(){

  Route::get('/',[App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');

  Route::get('dashboard/{submenu?}',[App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');

  Route::get('bahan_baku',[App\Http\Controllers\BahanBakuController::class, 'index'])->name('bahan_baku');
  Route::get('bahan_baku/detail',[App\Http\Controllers\BahanBakuController::class, 'detail'])->name('detail_bahan_baku');
  Route::post('bahan_baku/proses',[App\Http\Controllers\BahanBakuController::class, 'proses'])->name('proses_bahan_baku');

  Route::post('bahan_baku/pembelian/proses',[App\Http\Controllers\BahanBakuController::class, 'proses_pembelian'])->name('proses_pembelian_bahan_baku');

  Route::get('dapur/menu_makanan',[App\Http\Controllers\DapurController::class, 'menu_makanan'])->name('menu_makanan');
  Route::post('dapur/menu_makanan/proses',[App\Http\Controllers\DapurController::class, 'proses_menu_makanan'])->name('proses_menu_makanan');

  Route::get('dapur/menu_makanan/detail',[App\Http\Controllers\DapurController::class, 'detail_menu_makanan'])->name('detail_menu_makanan');
  Route::post('dapur/menu_makanan/komposisi/proses',[App\Http\Controllers\DapurController::class, 'proses_komposisi_menu'])->name('proses_komposisi_menu');
  Route::post('dapur/menu_makanan/nutrisi/proses',[App\Http\Controllers\DapurController::class, 'proses_nutrisi_menu'])->name('proses_nutrisi_menu');

  Route::get('dapur/jadwal_menu',[App\Http\Controllers\DapurController::class, 'jadwal_menu'])->name('jadwal_menu');
  Route::post('dapur/jadwal_menu/proses',[App\Http\Controllers\DapurController::class, 'proses_jadwal_menu'])->name('proses_jadwal_menu');

  Route::post('dapur/counter/{jenis}/proses',[App\Http\Controllers\DapurController::class, 'proses_counter_dapur'])->name('proses_counter_dapur');

  Route::get('dapur/jadwal_menu/detail',[App\Http\Controllers\DapurController::class, 'detail_jadwal_menu'])->name('detail_jadwal_menu');
  Route::post('dapur/jadwal_menu/pengolahan/proses',[App\Http\Controllers\DapurController::class, 'proses_pengolahan_makanan'])->name('proses_pengolahan_makanan');

  Route::get('penerima_manfaat',[App\Http\Controllers\PenerimaController::class, 'index'])->name('penerima_manfaat');
  Route::get('penerima_manfaat/form',[App\Http\Controllers\PenerimaController::class, 'form'])->name('form_penerima_manfaat');
  Route::get('penerima_manfaat/detail',[App\Http\Controllers\PenerimaController::class, 'detail'])->name('detail_penerima_manfaat');
  Route::post('penerima_manfaat/proses',[App\Http\Controllers\PenerimaController::class, 'proses'])->name('proses_penerima_manfaat');

  Route::get('pengiriman',[App\Http\Controllers\PengirimanController::class, 'index'])->name('pengiriman');
  Route::get('pengiriman/detail',[App\Http\Controllers\PengirimanController::class, 'detail'])->name('detail_pengiriman');
  Route::post('pengiriman/proses',[App\Http\Controllers\PengirimanController::class, 'proses'])->name('proses_pengiriman');


  Route::get('supplier',[App\Http\Controllers\SupplierController::class, 'index'])->name('supplier');
  Route::post('supplier/proses',[App\Http\Controllers\SupplierController::class, 'proses'])->name('proses_supplier');

  Route::get('user',[App\Http\Controllers\UserController::class, 'user'])->name('user');
  Route::post('user/proses',[App\Http\Controllers\UserController::class, 'proses_user'])->name('proses_user');

  Route::get('user/otoritas_modul',[App\Http\Controllers\UserController::class, 'otoritas_modul'])->name('otoritas_modul');
  Route::post('user/otoritas_modul/proses',[App\Http\Controllers\UserController::class, 'proses_otoritas_modul'])->name('proses_otoritas_modul');

  Route::get('master/kategori_bahan_baku',[App\Http\Controllers\MasterController::class, 'kategori_bahan_baku'])->name('kategori_bahan_baku');
  Route::post('master/kategori_bahan_baku/proses',[App\Http\Controllers\MasterController::class, 'proses_kategori_bahan_baku'])->name('proses_kategori_bahan_baku');

  Route::get('master/satuan_bahan_baku',[App\Http\Controllers\MasterController::class, 'satuan_bahan_baku'])->name('satuan_bahan_baku');
  Route::post('master/satuan_bahan_baku/proses',[App\Http\Controllers\MasterController::class, 'proses_satuan_bahan_baku'])->name('proses_satuan_bahan_baku');

  Route::get('master/periode_semester',[App\Http\Controllers\MasterController::class, 'periode_semester'])->name('periode_semester');
  Route::post('master/periode_semester/proses',[App\Http\Controllers\MasterController::class, 'proses_periode_semester'])->name('proses_periode_semester');

  Route::get('auth/logout/proses',[App\Http\Controllers\AuthController::class, 'proses_logout'])->name('proses_logout');

});
