<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row row-sm">
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Pasokan Bahan Baku Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="<?php echo e(route('dashboard',['submenu'=>'bahan_baku'])); ?>">Lihat Semua</a>
      </div>
      <div class="card-body">
        <div class="d-flex ht-100p">
          <div class="flex-fill">
            <div class="mg-b-20" id="pie_stok_bahan_baku"></div>
            <ul class="list-inline justify-content-center d-flex mg-b-20">
              <li class="list-inline-item d-flex align-items-center">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#16a085"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Cukup</span>
              </li>
              <li class="list-inline-item d-flex align-items-center mg-l-10">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#f39c12"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Rendah</span>
              </li>
              <li class="list-inline-item d-flex align-items-center mg-l-10">
                <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#c0392b"></span>
                <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Kritis</span>
              </li>
            </ul>
            <?php $__currentLoopData = $data['bahan-baku']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card rounded-10 mg-b-10">
              <div class="card-body pd-10">
                <div class="media">
                  <div class="image-wrapper rounded-10 mg-r-10 " style="aspect-ratio:1/1;width:50px;">
                    <img class="rounded-10" src="<?php echo e((!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )); ?>" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <p class="tx-medium mg-b-0"><?php echo e($value->nama_bahan); ?></p>
                    <small class="tx-11 tx-gray-500 mg-b-0"><?php echo e($value->nama_kategori); ?></small>
                  </div>
                </div>
              </div>
              <div class="card-footer pd-0">
                <div class="pd-x-10 pd-t-10">
                  <div class="d-flex">
                    <div class="flex-grow-1">
                      <span class="tx-11 tx-white rounded pd-x-8 pd-y-3" style="background:<?php echo e($value->color); ?>"><?php echo e($value->status); ?></span>
                    </div>
                    <a href="<?php echo e(route('detail_bahan_baku',['id'=>$value->id,'tab'=>'pembelian','mode'=>'order'])); ?>" class="align-self-center link-03 tx-12">Pesan Sekarang <i class="icon ion-md-arrow-forward mg-l-5"></i></a>
                  </div>
                </div>
                <hr style="margin-top: 0.7rem;margin-bottom: 0px;">
                <div class="pd-10">
                  <div class="d-flex">
                    <div class="wd-50p">
                      <div class="tx-11 tx-gray-700">Sisa Stok</div>
                      <h6 class="tx-12"><?php echo e($value->stok); ?> <?php echo e($value->satuan); ?></h6>
                    </div>
                    <div class="wd-50p">
                      <div class="tx-11 tx-gray-700">Kekurangan Stok</div>
                      <h6 class="tx-12"><?php echo e($value->kekurangan_stok); ?> <?php echo e($value->satuan); ?></h6>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <div class="divider-text divider-vertical" data-text="and"></div>
          <div class="flex-fill">
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="<?php echo e(asset('assets/images/bahan-baku-2.png')); ?>" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5"><?php echo e(GlobalHelper::jumlah_bahan_baku('all')); ?></h6>
                <div class="tx-gray-600">Total Bahan Baku</div>
              </div>
            </div>
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="<?php echo e(asset('assets/images/supplier.png')); ?>" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5"><?php echo e($data['jumlah-supplier']); ?></h6>
                <div class="tx-gray-600">Total Supplier</div>
              </div>
            </div>
            <div class="card rounded-10 mg-b-10">
              <div class="card-body tx-center">
                <img src="<?php echo e(asset('assets/images/order.png')); ?>" class="mg-b-10" style="width:50px">
                <h6 class="tx-30 mg-b-5">40</h6>
                <div class="tx-gray-600">Total Pesanan Berlangsung</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Dapur Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="<?php echo e(route('dashboard',['submenu'=>'dapur'])); ?>">Lihat Semua</a>
      </div>
      <div class="card-body">
        <h6>Status Produksi Makanan Bergizi Hari ini.</h6>
        <h6 class="tx-gray-500 mg-b-30"><?php echo e(GlobalHelper::nama_hari(date('Y-m-d'))); ?>, <?php echo e(GlobalHelper::tgl_indo(date('Y-m-d'))); ?></h6>
        <?php if(!empty($data['progres-produksi-makanan'])): ?>
          <div class="media mg-b-20 ">
            <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
              <img src="<?php echo e(url('storage/'.$data['progres-produksi-makanan']->gambar)); ?>" alt="" class="rounded-10">
            </div>
            <div class="media-body align-self-center ">
              <div class="mg-b-5 tx-15"><?php echo e($data['progres-produksi-makanan']->jumlah); ?> Porsi</div>
              <h5 class="mg-b-5 tx-20"><?php echo e($data['progres-produksi-makanan']->nama_menu); ?></h5>
              <?php if(!empty($data['progres-produksi-makanan']->status_produksi)): ?>
              <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:<?php echo e($data['progres-produksi-makanan']->color); ?>"> <?php echo e($data['progres-produksi-makanan']->status_produksi); ?> </span>
              <?php else: ?>
              <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
              <?php endif; ?>
            </div>
          </div>
          <div class="card rounded-10 mg-b-10">
            <div class="card-body">
              <h5>Komposisi Makanan</h5>
              <table class="table table-vertical-middle">
                <tbody>
                  <?php $__currentLoopData = $data['progres-produksi-makanan']->komposisi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td style="<?php echo e(($key == 0 ? 'border-top:0 !important' : null )); ?>">
                        <div class="media">
                          <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:50px;padding:2px">
                            <img src="<?php echo e(url('storage/'.$value->gambar)); ?>" alt="">
                          </div>
                          <div class="media-body align-self-center ">
                            <h6><?php echo e($value->nama_bahan); ?></h6>
                            <div><?php echo e($value->jumlah); ?> <?php echo e($value->satuan); ?></div>
                          </div>
                        </div>
                      </td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
          <div class="row row-xs">
            <?php $__currentLoopData = $data['progres-produksi-makanan']->nutrisi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-3">
              <div class="card rounded-10">
                <div class="card-body pd-10 text-center">
                  <h3 class="tx-30 mg-b-0"><?php echo e($value->jumlah); ?></h3>
                  <h5 class="tx-15 mg-b-0"><?php echo e($value->nama_nutrisi); ?></h5>
                  <p class="text-muted"><?php echo e($value->satuan); ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <div class="row row-xs mg-t-10">
            <div class="col-md-6">
              <div class="card rounded-10 mg-b-10 bg-gray-100">
                <div class="card-body tx-center">
                  <h6>Pencucian Alat Makan</h6>
                  <div id="progres_cuci_piring"></div>
                </div>
              </div>
            </div>
            <div class="col-md-6">
              <div class="card rounded-10 mg-b-10 bg-gray-100">
                <div class="card-body tx-center">
                  <h6>Pemorsian / Pengepakan</h6>
                  <div id="progres_pengemasan"></div>
                </div>
              </div>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Distribusi Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="<?php echo e(route('dashboard',['submenu'=>'distribusi'])); ?>">Lihat Semua</a>
      </div>
      <div class="card-body pd-10">
        <div id="map" class="rounded-20 bg-gray-500 ht-100p" style="width:100%;aspect-ratio:1/1"></div>
      </div>
    </div>
  </div>
  <div class="col-md-6 mg-b-20">
    <div class="card ht-100p rounded-20">
      <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
        <h6 class="mg-b-0">Penerima Manfaat Makanan Bergizi</h6>
        <a class="btn btn-sm btn-primary" target="_blank" href="<?php echo e(route('dashboard',['submenu'=>'penerima_manfaat'])); ?>">Lihat Semua</a>
      </div>
      <div class="card-body">
        <div class="row row-xs">
          <div class="col-md-6">
            <div class="card rounded-10">
              <div class="card-body">
                <div class="media">
                  <img src="<?php echo e(asset('assets/images/school.png')); ?>" class="mg-r-10" style="width:60px">
                  <div class="media-body align-self-center ">
                    <h6 class="tx-20 mb-0"><?php echo e($data['jumlah-sekolah']); ?></h6>
                    <div class="tx-gray-600">Total Sekolah</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card rounded-10">
              <div class="card-body">
                <div class="media">
                  <img src="<?php echo e(asset('assets/images/students.png')); ?>" class="mg-r-10" style="width:60px">
                  <div class="media-body align-self-center ">
                    <h6 class="tx-20 mb-0"><?php echo e($data['jumlah-siswa']); ?></h6>
                    <div class="tx-gray-600">Total Peserta Didik</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="card mg-t-20 rounded-10">
          <div class="card-body">
            <div class="" id="pie_jumlah_siswa"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="card ht-100p rounded-20">
  <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
    <h6 class="mg-b-0">CCTV Dapur Makanan Bergizi</h6>
    <a class="btn btn-sm btn-primary" target="_blank" href="<?php echo e(route('dashboard',['submenu'=>'cctv_dapur'])); ?>">Lihat Semua</a>
  </div>
  <div class="card-body">
    <div class="row row-sm">
      <?php for($i=0; $i < 6; $i++): ?>
        <div class="col-md-4">
          <div class="image-wrapper bg-gray-500 rounded-20 mg-b-20" style="aspect-ratio:4/3">
            <img class="rounded-10" src="<?php echo e(asset('assets/images/cctv-offline.jpg')); ?>" alt="">
          </div>
        </div>
      <?php endfor; ?>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDymbs_1T1obAHoub1_27J5sj-cG_q0pIs"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>
  $(document).ready(function () {
      let dapur = { lat: -7.427628551783064, lng: 112.70805805303137 };
      <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      let sekolah<?php echo e($value->id); ?> = { lat: <?php echo e($value->latitude); ?>, lng: <?php echo e($value->longitude); ?> };
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      const mapOptions = {
          center: dapur,
          zoom: 10,
      };

      const map = new google.maps.Map(document.getElementById('map'), mapOptions);

      <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        const directionsService<?php echo e($value->id); ?> = new google.maps.DirectionsService();
        const directionsRenderer<?php echo e($value->id); ?> = new google.maps.DirectionsRenderer({
            map: map,
            polylineOptions: {
                strokeColor: "<?php echo e($value->color); ?>",
                strokeOpacity: 0.5,
                strokeWeight: 7
            }
        });
        const request<?php echo e($value->id); ?> = {
            origin: dapur,
            destination: sekolah<?php echo e($value->id); ?>,
            travelMode: google.maps.TravelMode.DRIVING,
        };
        directionsService<?php echo e($value->id); ?>.route(request<?php echo e($value->id); ?>, function (result, status) {
          if (status === google.maps.DirectionsStatus.OK) {
              directionsRenderer<?php echo e($value->id); ?>.setDirections(result);

              const route = result.routes[0].legs[0];
              const distance = route.distance.text;
              const duration = route.duration.text;

              const info = `Distance: ${distance}, Estimated Time: ${duration}`;
          } else {
              console.error("Directions request failed due to " + status);
          }
        });
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  });


  get_pie_stok_bahan_baku(<?php echo e(GlobalHelper::jumlah_bahan_baku('normal')); ?>,<?php echo e(GlobalHelper::jumlah_bahan_baku('rendah')); ?>,<?php echo e(GlobalHelper::jumlah_bahan_baku('kritis')); ?>);
  function get_pie_stok_bahan_baku(cukup,rendah,kritis){
    var options = {
      series: [cukup,rendah,kritis],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 1,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Cukup", "Rendah", "Kritis"],
  		colors: ["#16a085","#f39c12","#c0392b"]
    };
    var chart = new ApexCharts(document.querySelector("#pie_stok_bahan_baku"), options);
    chart.render();
  }

  get_pie_jumlah_siswa(<?php echo e($data['jumlah-laki-laki']); ?>,<?php echo e($data['jumlah-perempuan']); ?>);
  function get_pie_jumlah_siswa(laki_laki,perempuan){
    var options = {
      series: [laki_laki,perempuan],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 0.8,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Laki-Laki", "Perempuan"],
  		colors: ["#2d98da","#ef5777"],
      legend: {
        show: true,
        position: 'bottom'
      }
    };
    var chart = new ApexCharts(document.querySelector("#pie_jumlah_siswa"), options);
    chart.render();
  }

  <?php if(!empty($data['progres-produksi-makanan'])): ?>
  get_chart_progres_cuci_piring(<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['persentase']); ?>);
  function get_chart_progres_cuci_piring(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$data['progres-produksi-makanan']->id)['color']); ?>"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_cuci_piring"), options);
    chart.render();
  }

  get_chart_progres_pengemasan(<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['persentase']); ?>);
  function get_chart_progres_pengemasan(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$data['progres-produksi-makanan']->id)['color']); ?>"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_pengemasan"), options);
    chart.render();
  }
  <?php endif; ?>
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/dashboard/index.blade.php ENDPATH**/ ?>