<?php $__env->startSection('content'); ?>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-xs">
          <div class="col-md-10">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" name="search" value="<?php echo e($search); ?>" placeholder="Search">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-2">
            <button type="button" class="btn btn-block btn-dark" onclick="add_satuan()" >Tambah Satuan</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead>
          <tr>
            <th width="50">No</th>
            <th width="150px">Satuan</th>
            <th width="150px">Satuan Komposisi</th>
            <th>Formula Konversi</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $data['satuan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['satuan']->firstItem() + $key); ?></td>
              <td><?php echo e($value->satuan); ?></td>
              <td><?php echo e($value->satuan_komposisi); ?></td>
              <td><?php echo e($value->formula_konversi); ?></td>
              <td style="width:1px;white-space:nowrap;">
                <a href="javascript:;" onclick="edit_satuan('<?php echo e($value->id); ?>')" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete(<?php echo e($value->id); ?>)" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="<?php echo e(route('proses_satuan_bahan_baku')); ?>" method="post" id="hapus<?php echo e($value->id); ?>">
                  <?php echo e(csrf_field()); ?>

                  <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20"><?php echo e($data['satuan']->links('include.pagination', ['pagination' => $data['satuan']] )); ?></div>
    </div>
  </div>

  <div class="modal fade" role="dialog" id="modal-satuan">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_satuan_bahan_baku')); ?>" method="POST" enctype="multipart/form-data" data-parsley-validate>
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="form-group">
              <label>Satuan Baku</label>
              <input type="text" class="form-control" name="satuan" id="satuan" required data-parsley-required-message="Satuan tidak boleh kosong" >
            </div>
            <div class="form-group">
              <label>Satuan Komposisi</label>
              <input type="text" class="form-control" name="satuan_komposisi" id="satuan_komposisi" required data-parsley-required-message="Satuan Komposisi tidak boleh kosong" >
            </div>
            <div class="form-group">
              <label>Formula Konversi</label>
              <input type="text" class="form-control" name="formula_konversi" id="formula_konversi" required data-parsley-required-message="Formula Konversi tidak boleh kosong" >
            </div>
            <div class="alert alert-danger" role="alert">Formula Konversi adalah formula untuk mengkoversi nilai dari satuan komposisi ke satuan bahan baku, misal satuan bahan baku Kg dan satuan konversi gram, maka formulanya /1000 (dibagi 1000), Jika satuan komposisi dan satuan bahan baku sama, maka formulai konversinya *1 (dikali 1).</div>
          </div>
          <div class="modal-footer">
            <input type="hidden" id="id" name="id">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kembali</button>
            <button type="submit" class="btn btn-primary" id="action" name="action" value="add">Tambahkan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  function add_satuan(){
    $('#satuan').val('');
    $('#satuan_komposisi').val('');
    $('#formula_konversi').val('');
    $('#id').val(0);
    $('#title').html('Tambah Satuan Bahan Baku');
    $('#action').val('add');
    $('#action').html('Tambahkan');
    $('#modal-satuan').modal('show');
  }

  function edit_satuan(id){
    $.get("<?php echo e(url('api/find_satuan_bahan_baku')); ?>/"+id,function(result){
      $('#satuan').val(result.satuan);
      $('#satuan_komposisi').val(result.satuan_komposisi);
      $('#formula_konversi').val(result.formula_konversi);
      $('#id').val(id);
      $('#title').html('Edit Satuan Bahan Baku');
      $('#action').val('edit');
      $('#action').html('Simpan');
      $('#modal-satuan').modal('show');
    });
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/master/satuan_bahan_baku.blade.php ENDPATH**/ ?>