<?php $__env->startSection('content'); ?>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-xs">
          <div class="col-md-10">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" name="search" value="<?php echo e($search); ?>" placeholder="Search">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-2">
            <button type="button" class="btn btn-block btn-dark" onclick="add_semester()" >Tambah Satuan</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead>
          <tr>
            <th width="50">No</th>
            <th width="150px">Semester</th>
            <th width="150px">Tahun Pelajaran</th>
            <th>Rentang Tanggal</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $data['semester']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['semester']->firstItem() + $key); ?></td>
              <td><?php echo e($value->semester); ?></td>
              <td><?php echo e($value->tahun_pelajaran); ?></td>
              <td><?php echo e(GlobalHelper::tgl_indo($value->tanggal_mulai)); ?> s/d <?php echo e(GlobalHelper::tgl_indo($value->tanggal_akhir)); ?></td>
              <td style="width:1px;white-space:nowrap;">
                <a href="javascript:;" onclick="edit_semester('<?php echo e($value->id); ?>')" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete(<?php echo e($value->id); ?>)" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="<?php echo e(route('proses_periode_semester')); ?>" method="post" id="hapus<?php echo e($value->id); ?>">
                  <?php echo e(csrf_field()); ?>

                  <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20"><?php echo e($data['semester']->links('include.pagination', ['pagination' => $data['semester']] )); ?></div>
    </div>
  </div>

  <div class="modal fade" role="dialog" id="modal-semester">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_periode_semester')); ?>" method="POST" enctype="multipart/form-data" data-parsley-validate>
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Tahun Pelajaran</label>
                  <div class="input-group">
                    <input type="text" class="form-control numeric tahun_pelajaran" autocomplete="off" name="tahun_awal" id="tahun_awal" required data-parsley-required-message="Tahun Awal tidak boleh kosong" />
                    <input type="text" class="form-control numeric tahun_pelajaran" autocomplete="off" name="tahun_akhir" id="tahun_akhir" required data-parsley-required-message="Tahun Akhir tidak boleh kosong" />
                  </div>
                  <div class="tahun-massage"></div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Semsester</label>
                  <select class="select2" name="semester" id="semester" style="width:100%">
                    <option value="Ganjil" >Ganjil</option>
                    <option value="Genap" >Genap</option>
                  </select>
                </div>
              </div>
            </div>
            <div class="form-group">
              <label>Periode Tanggal</label>
              <div class="input-daterange input-group" data-date-format="dd-mm-yyyy" data-provide="datepicker">
                <input type="text" class="form-control range_tanggal" autocomplete="off" name="tanggal_mulai" id="tanggal_mulai" required data-parsley-required-message="Tanggal Mulai tidak boleh kosong" />
                <input type="text" class="form-control range_tanggal" autocomplete="off" name="tanggal_akhir" id="tanggal_akhir" required data-parsley-required-message="Tanggal Akhir tidak boleh kosong"  />
              </div>
              <div class="tanggal-massage"></div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" id="id" name="id">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Kembali</button>
            <button type="submit" class="btn btn-primary" id="action" name="action" value="add">Tambahkan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>

  $('.tahun_pelajaran').parsley({
    errorsContainer: function (ParsleyField) {
      return ParsleyField.$element.closest('.form-group').find('.tahun-massage');
    }
  });

  $('.range_tanggal').parsley({
    errorsContainer: function (ParsleyField) {
      return ParsleyField.$element.closest('.form-group').find('.tanggal-massage');
    }
  });

  function add_semester(){
    $('#tahun_awal').val('');
    $('#tahun_akhir').val('');
    $('#tanggal_mulai').val('');
    $('#tanggal_akhir').val('');
    $('#id').val(0);
    $('#title').html('Tambah Periode Semester');
    $('#action').val('add');
    $('#action').html('Tambahkan');
    $('#modal-semester').modal('show');
  }

  function edit_semester(id){
    $.get("<?php echo e(url('api/find_periode_semester')); ?>/"+id,function(result){
      $('#tahun_awal').val(result.tahun_awal);
      $('#tahun_akhir').val(result.tahun_akhir);
      $('#tanggal_mulai').val(result.tanggal_mulai);
      $('#tanggal_akhir').val(result.tanggal_akhir);
      $('#id').val(id);
      $('#title').html('Edit Periode Semester');
      $('#action').val('edit');
      $('#action').html('Simpan');
      $('#modal-semester').modal('show');
    });
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/master/periode_semester.blade.php ENDPATH**/ ?>