<?php $__env->startSection('content'); ?>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" name="search" value="<?php echo e($search); ?>" placeholder="Cari Data Pemasok">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-4">
            <button class="btn btn-primary pull-right" onclick="add_pemasok()">Tambah Pemasok</button>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th>Nama Pemasok</th>
            <th>No. Telephone</th>
            <th>Email</th>
            <th>Alamat</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $data['pemasok']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['pemasok']->firstItem() + $key); ?></td>
              <td><h6><?php echo e($value->nama_pemasok); ?></h6></td>
              <td><?php echo (!empty($value->no_handphone) ? $value->no_handphone : '---' ); ?></td>
              <td><?php echo (!empty($value->email) ? $value->email : '---' ); ?></td>
              <td><?php echo (!empty($value->alamat) ? $value->alamat : '---' ); ?></td>
              <td style="width:1px;white-space:nowrap;">
                <a href="javascript:;" onclick="edit_pemasok(<?php echo e($value->id); ?>)" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete(<?php echo e($value->id); ?>)" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="<?php echo e(route('proses_supplier')); ?>" method="post" id="hapus<?php echo e($value->id); ?>">
                  <?php echo e(csrf_field()); ?>

                  <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20"><?php echo e($data['pemasok']->links('include.pagination', ['pagination' => $data['pemasok']] )); ?></div>
    </div>
  </div>

  <div class="modal fade" id="modal-pemasok" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_supplier')); ?>" method="post" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="form-group">
              <label>Nama Pemasok</label>
              <input type="text" class="form-control" id="nama_pemasok" name="nama_pemasok" required >
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>No. Handphone</label>
                  <input type="text" class="form-control" id="no_handphone" name="no_handphone" required >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Email</label>
                  <input type="text" class="form-control" id="email" name="email" required >
                </div>
              </div>
            </div>
            <div class="form-group">
              <label>Alamat</label>
              <input type="text" class="form-control" id="alamat" name="alamat" required >
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
function add_pemasok(){
  $('#nama_pemasok').val('');
  $('#email').val('');
  $('#no_handphone').val('');
  $('#alamat').val('');
  $('#id').val(0);
  $('#action').val('add');
  $('#title').html('Tambah Pemasok Bahan Baku');
  $('#modal-pemasok').modal('show');
}

function edit_pemasok(id){
  $.get("<?php echo e(url('api/find_pemasok_bahan_baku')); ?>/"+id,function(result){
    $('#nama_pemasok').val(result.nama_pemasok);
    $('#email').val(result.email);
    $('#no_handphone').val(result.no_handphone);
    $('#alamat').val(result.alamat);
    $('#id').val(id);
    $('#action').val('edit');
    $('#title').html('Edit Pemasok Bahan Baku');
    $('#modal-pemasok').modal('show');
  });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/supplier/index.blade.php ENDPATH**/ ?>