<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}
#marker {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  background:url('<?php echo e(asset('assets/images/location.png')); ?>') no-repeat top center;
  background-size:100%;
  opacity: 1;
  cursor: move;
  z-index: 9000
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="card ht-100p rounded-20">
    <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
      <h4 class="mg-b-0">CCTV Dapur Makanan Bergizi</h4>
    </div>
    <div class="card-body">
      <div class="row row-sm">
        <?php for($i=0; $i < 8; $i++): ?>
          <div class="col-md-3">
            <div class="image-wrapper bg-gray-500 rounded-20 mg-b-20" style="aspect-ratio:4/3">
              <img class="rounded-10" src="<?php echo e(asset('assets/images/cctv-offline.jpg')); ?>" alt="">
            </div>
          </div>
        <?php endfor; ?>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="https://cdn.jsdelivr.net/npm/ol@v9.0.0/dist/ol.js"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>

  get_pie_jumlah_siswa(<?php echo e($data['jumlah-laki-laki']); ?>,<?php echo e($data['jumlah-perempuan']); ?>);
  function get_pie_jumlah_siswa(laki_laki,perempuan){
    var options = {
      series: [laki_laki,perempuan],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 0.8,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Laki-Laki", "Perempuan"],
  		colors: ["#2d98da","#ef5777"],
      legend: {
        show: true,
        position: 'bottom'
      }
    };
    var chart = new ApexCharts(document.querySelector("#pie_jumlah_siswa"), options);
    chart.render();
  }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/dashboard/cctv_dapur.blade.php ENDPATH**/ ?>