<?php $__env->startSection('content'); ?>
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
      <img src="<?php echo e((!empty($data['bahan-baku']->gambar) ? asset('storage/'.$data['bahan-baku']->gambar) : asset('assets/images/image-default.jpg') )); ?>" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <h5 class="mb-0"><?php echo e($data['bahan-baku']->nama_bahan); ?></h5>
      <div class="mg-b-10"><?php echo e($data['bahan-baku']->nama_kategori); ?></div>
      <button class="btn btn-xs btn-primary" onclick="edit_bahan_baku(<?php echo e($data['bahan-baku']->id); ?>)" >Edit Bahan Baku</button>
      <button class="btn btn-xs btn-success" onclick="add_pembelian_bahan_baku()" >Beli Bahan Baku</button>
    </div>
  </div>
  <div class="card card-table rounded-20" style="min-height: calc(100vh - 275px )">
    <div class="card-body">
      <div class="pd-20">
        <ul class="nav nav-pills">
          <li class="nav-item">
            <a class="nav-link <?php echo e(($tab == 'informasi' ? 'active' : null )); ?>" href="<?php echo e(route('detail_bahan_baku',['id'=>$id,'tab'=>'informasi'])); ?>">Informasi Bahan</a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?php echo e(($tab == 'pembelian' ? 'active' : null )); ?>" href="<?php echo e(route('detail_bahan_baku',['id'=>$id,'tab'=>'pembelian'])); ?>">Pembelian Bahan</a>
          </li>
          <li class="nav-item">
            <a class="nav-link <?php echo e(($tab == 'penggunaan' ? 'active' : null )); ?>" href="<?php echo e(route('detail_bahan_baku',['id'=>$id,'tab'=>'penggunaan'])); ?>">Penggunaan Bahan</a>
          </li>
        </ul>
      </div>
      <div class="mg-t-20"><?php echo $__env->make('kelola_bahan_baku.detail.'.$tab, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
    </div>
  </div>
  <div class="modal fade" id="modal-bahan-baku" role="dialog">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_bahan_baku')); ?>" method="post" enctype="multipart/form-data" data-parsley-validate >
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="row">
              <div class="col-md-7">
                <div class="form-group">
                  <label>Nama Bahan Baku</label>
                  <input type="text" class="form-control" id="nama_bahan" name="nama_bahan" required data-parsley-required-message="Nama Bahan Baku tidak boleh kosong" >
                </div>
                <div class="row row-xs">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Kategori</label>
                      <select class="select2" style="width:100%" id="kategori" name="kategori">
                        <?php $__currentLoopData = $data['kategori']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value->id); ?>"><?php echo e($value->nama_kategori); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Satuan</label>
                      <select class="select2" style="width:100%" id="satuan" name="satuan">
                        <?php $__currentLoopData = $data['satuan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value->id); ?>"><?php echo e($value->satuan); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Deskripsi</label>
                  <textarea class="form-control" id="deskripsi" name="deskripsi"></textarea>
                </div>
                <div class="row row-xs">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Maksimum</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_maksimum" name="stok_maksimum" required  data-parsley-required-message="Stok Maksimum tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Rendah</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_rendah" name="stok_rendah" required data-parsley-required-message="Stok Rendah tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Kritis</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_kritis" name="stok_kritis" required data-parsley-required-message="Stok Kritis tidak boleh kosong">
                    </div>
                  </div>
                </div>
                <div class="row row-xs">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Stok Awal</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="stok_awal" name="stok_awal" required data-parsley-required-message="Stok Awal tidak boleh kosong">
                    </div>
                  </div>
                  <div class="col-md-8">
                    <div class="form-group">
                      <label>Harga Beli</label>
                      <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="harga_beli" name="harga_beli" required data-parsley-required-message="Harga Beli tidak boleh kosong">
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <label>Upload Gambar</label>
                  <input type="file" class="dropify" id="gambar" name="gambar" data-default-file="">
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-pembelian-bahan-baku" role="dialog">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_pembelian_bahan_baku',['bahan_baku'=>$data['bahan-baku']->id])); ?>" method="post" enctype="multipart/form-data" data-parsley-validate >
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="row">
              <div class="col-md-6">
                <div class="row row-xs">
                  <div class="col-md-5">
                    <div class="form-group">
                      <label>Tanggal Pembelian</label>
                      <input
                        type="text" class="form-control datepicker"
                        autocomplete="off" id="tanggal" name="tanggal"
                        required data-parsley-required-message="Tanggal tidak boleh kosong"
                        data-parsley-dateformat data-parsley-dateformat-message="Tanggal harus dalam format dd-mm-yyyy."
                      >
                    </div>
                  </div>
                  <div class="col-md-7">
                    <div class="form-group">
                      <label>Jumlah</label>
                      <div class="input-group">
                        <input
                          type="text"
                          class="form-control autonumeric"
                          data-a-dec="," data-a-sep="."
                          id="jumlah" name="jumlah"
                          required data-parsley-required-message="Jumlah tidak boleh kosong."
                        >
                        <div class="input-group-append">
                          <span class="input-group-text"><?php echo e($data['bahan-baku']->satuan); ?></span>
                        </div>
                      </div>
                      <div class="error-message"></div> <!-- Kontainer untuk pesan error -->
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Harga Beli</label>
                  <input type="text" class="form-control autonumeric" data-a-dec="," data-a-sep="." id="harga_beli" name="harga_beli" required data-parsley-required-message="Harga Beli tidak boleh kosong" >
                </div>
                <div class="form-group">
                  <label>Kanal Pembelian</label>
                  <input type="text" class="form-control" id="kanal_pembelian" name="kanal_pembelian" required data-parsley-required-message="Kanal Pembelian tidak boleh kosong" >
                </div>
                <div class="form-group">
                  <label>Keterangan</label>
                  <input type="text" class="form-control" id="keterangan" name="keterangan" >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Pilih Pemasok</label>
                  <select class="select2" style="width:100%" name="pilih_pemasok" id="pilih_pemasok" >
                    <option value="0">Tambah Pemasok Baru</option>
                    <?php $__currentLoopData = $data['pemasok']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($value->id); ?>"><?php echo e($value->nama_pemasok); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>
                <div class="form-group">
                  <label>Nama Pemasok</label>
                  <input type="text" class="form-control" id="nama_pemasok" name="nama_pemasok" required data-parsley-required-message="Nama Pemasok tidak boleh kosong" >
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>No. Handphone</label>
                      <input type="text" class="form-control numeric" id="no_handphone" name="no_handphone" required data-parsley-required-message="Nomor Handphone tidak boleh kosong" >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Email</label>
                      <input type="email" class="form-control" id="email" name="email" required data-parsley-required-message="Email tidak boleh kosong" data-parsley-type="email" data-parsley-type-message="Masukkan email yang valid, contoh: user@example.com." >
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <label>Alamat</label>
                  <input type="text" class="form-control" id="alamat" name="alamat" required data-parsley-required-message="Alamat tidak boleh kosong" >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <input type="hidden" name="id" id="id" >
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" id="action">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script>
  Parsley.addValidator('dateformat', {
    validateString: function (value) {
      // Regex untuk format tanggal d-m-Y
      const dateRegex = /^([0-2][0-9]|(3)[0-1])-((0)[0-9]|(1)[0-2])-\d{4}$/;
      return dateRegex.test(value); // Valid jika regex cocok
    },
    messages: {
      en: "The date must be in the format dd-mm-yyyy.",
      id: "Tanggal harus dalam format dd-mm-yyyy."
    }
  });

  $('#jumlah').parsley({
    errorPlacement: function (error, element) {
      if (element.parent().hasClass('input-group')) {
        error.appendTo(element.closest('.form-group').find('.error-message'));
      } else {
        error.insertAfter(element);
      }
    },
    errorsContainer: function (ParsleyField) {
      return ParsleyField.$element.closest('.form-group').find('.error-message');
    }
  });

  <?php if($mode == 'order'): ?>
  add_pembelian_bahan_baku()
  <?php endif; ?>
  function edit_bahan_baku(id){
    $.get("<?php echo e(url('api/find_bahan_baku')); ?>/"+id,function(result){
      $('#modal-bahan-baku #nama_bahan').val(result.nama_bahan);
      $('#modal-bahan-baku #stok_maksimum').val(result.stok_maksimum);
      $('#modal-bahan-baku #stok_rendah').val(result.stok_rendah);
      $('#modal-bahan-baku #stok_kritis').val(result.stok_kritis);
      $('#modal-bahan-baku #stok_awal').val(result.stok_awal);
      $('#modal-bahan-baku #harga_beli').val(result.harga_beli);
      $('#modal-bahan-baku #deskripsi').val(result.deskripsi);

      $('#modal-bahan-baku #satuan').val(result.fid_satuan);
      $('#modal-bahan-baku #satuan').select2();

      $('#modal-bahan-baku #kategori').val(result.fid_kategori);
      $('#modal-bahan-baku #kategori').select2();

      var dropify = $('#modal-bahan-baku #gambar').dropify();
      var dropifyElement = dropify.data('dropify'); // Access dropify instance
      dropifyElement.settings.defaultFile = result.gambar; // Set image URL
      dropifyElement.destroy(); // Destroy current instance
      dropifyElement.init(); // Reinitialize Dropify

      $('#modal-bahan-baku #id').val(id);
      $('#modal-bahan-baku #action').val('edit');
      $('#modal-bahan-baku #title').html('Edit Bahan Baku');
      $('#modal-bahan-baku').modal('show');
    });
  }

  $('#modal-pembelian-bahan-baku #pilih_pemasok').change(function () {
    id =$(this).val();
    $.get("<?php echo e(url('api/find_pemasok_bahan_baku')); ?>/"+id,function(result){
      $('#modal-pembelian-bahan-baku #nama_pemasok').val(result.nama_pemasok);
      $('#modal-pembelian-bahan-baku #email').val(result.email);
      $('#modal-pembelian-bahan-baku #no_handphone').val(result.no_handphone);
      $('#modal-pembelian-bahan-baku #alamat').val(result.alamat);
    });
  });

  function add_pembelian_bahan_baku(){
    $('#modal-pembelian-bahan-baku #tanggal').val('<?php echo e(date('d-m-Y')); ?>');
    $('#modal-pembelian-bahan-baku #jumlah').val('');
    $('#modal-pembelian-bahan-baku #kanal_pembelian').val('');
    $('#modal-pembelian-bahan-baku #keterangan').val('');
    $('#modal-pembelian-bahan-baku #harga_beli').val('<?php echo e(number_format($data['bahan-baku']->harga_beli,0,',','.')); ?>');

    $('#modal-pembelian-bahan-baku #pilih_pemasok').val(0);
    $('#modal-pembelian-bahan-baku #pilih_pemasok').select2();

    $('#modal-pembelian-bahan-baku #pilih_pemasok').trigger('change');

    $('#modal-pembelian-bahan-baku #id').val(0);
    $('#modal-pembelian-bahan-baku #action').val('add');
    $('#modal-pembelian-bahan-baku #title').html('Tambah Pembelian Bahan Baku');
    $('#modal-pembelian-bahan-baku').modal('show');
  }

  function edit_pembelian_bahan_baku(id){
    $.get("<?php echo e(url('api/find_pembelian_bahan_baku')); ?>/"+id,function(result){
      $('#modal-pembelian-bahan-baku #tanggal').val(result.tanggal);
      $('#modal-pembelian-bahan-baku #jumlah').val(result.jumlah);
      $('#modal-pembelian-bahan-baku #kanal_pembelian').val(result.kanal_pembelian);
      $('#modal-pembelian-bahan-baku #keterangan').val(result.keterangan);
      $('#modal-pembelian-bahan-baku #harga_beli').val(result.harga_beli);

      $('#modal-pembelian-bahan-baku #pilih_pemasok').val(id);
      $('#modal-pembelian-bahan-baku #pilih_pemasok').select2();

      $('#modal-pembelian-bahan-baku #pilih_pemasok').trigger('change');

      $('#modal-pembelian-bahan-baku #id').val(id);
      $('#modal-pembelian-bahan-baku #action').val('edit');
      $('#modal-pembelian-bahan-baku #title').html('Edit Pembelian Bahan Baku');
      $('#modal-pembelian-bahan-baku').modal('show');
    });
  }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/kelola_bahan_baku/detail/index.blade.php ENDPATH**/ ?>