<?php $__env->startSection('css'); ?>
  <style>
  @media (min-width: 768px){
    .timeline-label {
      margin-left: 80px;
    }
    .timeline-time {
      width: 80px;
    }
    .timeline-item + .timeline-item::before {
      left: 80px;
    }
  }
  .timeline-body::before{
    border: 2px solid #455b00;
  }
  .timeline-body h6{
    color: #455b00;
    margin-bottom: 5px;
  }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
      <img src="<?php echo e((!empty($data['jadwal-menu']->gambar) ? asset('storage/'.$data['jadwal-menu']->gambar) : asset('assets/images/image-default.jpg') )); ?>" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <div class="mg-b-5 tx-15"><?php echo e($data['jadwal-menu']->jumlah); ?> Porsi</div>
      <h5 class="mg-b-5 tx-20"><?php echo e($data['jadwal-menu']->nama_menu); ?></h5>
      <?php if(!empty($data['jadwal-menu']->status_produksi)): ?>
      <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:<?php echo e($data['jadwal-menu']->color); ?>"> <?php echo e($data['jadwal-menu']->status_produksi); ?> </span>
      <?php else: ?>
      <span class="badge badge-pill tx-white pd-x-10 pd-y-7" style="background:#7f8c8d"> Belum Diproses </span>
      <?php endif; ?>
    </div>
  </div>
  <div class="card <?php echo e(($page == 'form-pengiriman' ? 'card-table' : null)); ?> rounded-20" style="min-height: calc(100vh - 275px )">
    <?php if($page == 'form-pengiriman'): ?>
      <div class="pd-30">
        <h5>Form Pengiriman Makanan</h5>
        <p class="mg-b-0">Silahkan tentukan pengemudi untuk setiap tujuan dari penerima manfaat</p>
      </div>
      <form action="<?php echo e(route('proses_pengiriman')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <table class="table table-vertical-middle">
          <thead class="thead-light">
            <tr>
              <th width="50px">No</th>
              <th>Penerima Manfaat</th>
              <th width="80px" class="tx-center">Jumlah<br>Porsi</th>
              <th width="300px">Nama Pengemudi</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($key+1); ?></td>
                <td>
                  <div class="media">
                    <div class="image-wrapper rounded mg-r-10 " style="aspect-ratio:1/1;width:60px;padding:3px">
                      <img src="<?php echo e((!empty($value->logo) ? asset('storage/'.$value->logo) : asset('assets/images/image-default.jpg') )); ?>" alt="">
                    </div>
                    <div class="media-body align-self-center ">
                      <h6><?php echo e($value->nama_sekolah); ?></h6>
                      <div><?php echo (!empty($value->alamat) ? $value->alamat : '---' ); ?>, RT <?php echo e($value->rt); ?> / RW <?php echo e($value->rw); ?></div>
                    </div>
                  </div>
                </td>
                <td class="tx-center"><?php echo e($value->total); ?></td>
                <td>
                  <input type="hidden" name="penerima[]" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="jumlah[<?php echo e($value->id); ?>]" value="<?php echo e($value->total); ?>">
                  <select class="select2 form-control" name="pengemudi[<?php echo e($value->id); ?>]">
                    <?php $__currentLoopData = $data['driver']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value->id); ?>"><?php echo e($value->nama_lengkap); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
        <hr>
        <div class="pd-x-30 pd-b-20">
          <div class="row">
            <div class="col-md-12">
              <div class="pull-right">
                <input type="hidden" name="jadwal" value="<?php echo e($data['jadwal-menu']->id); ?>">
                <a class="btn btn-dark" href="<?php echo e(route('detail_jadwal_menu',['id'=>$data['jadwal-menu']->id])); ?>">Kembali</a>
                <button class="btn btn-primary" name="action" value="add" >Simpan</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    <?php else: ?>
    <div class="card-body pd-0">
      <div class="row row-xs">
        <div class="col-md-5">
          <div class="pd-30">
            <h5 class="mg-b-15">Komposisi Makanan</h5>
            <table class="table table-vertical-middle">
              <tbody>
                <?php $__currentLoopData = $data['komposisi']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td style="<?php echo e(($key == 0 ? 'border-top:0 !important' : null )); ?>">
                      <div class="media">
                        <div class="image-wrapper mg-r-20 " style="aspect-ratio:1/1;width:60px;padding:2px">
                          <img src="<?php echo e(url('storage/'.$value->gambar)); ?>" alt="">
                        </div>
                        <div class="media-body align-self-center ">
                          <h6><?php echo e($value->nama_bahan); ?></h6>
                          <div><?php echo e($value->jumlah); ?> <?php echo e($value->satuan_komposisi); ?></div>
                        </div>
                      </div>
                    </td>
                    <td style="text-align:right;<?php echo e(($key == 0 ? 'border-top:0 !important' : null )); ?>">
                      <span class="tx-11 tx-white rounded pd-x-8 pd-y-3 mg-b-5" style="background:<?php echo e($value->status['color']); ?>"><?php echo e($value->status['status']); ?></span>
                      <div><?php echo e($value->kebutuhan); ?> <?php echo e($value->satuan); ?></div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
            
            <h5 class="mg-b-15 mg-t-30">Kandungan Nutrisi</h5>
            <div class="row row-sm mg-b-30">
              <?php $__currentLoopData = $data['nutrisi']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="col-md-6">
                <div class="card rounded-20 mg-b-20">
                  <div class="card-body pd-10 text-center">
                    <h3 class="tx-30 fw-bold"><?php echo e($value->jumlah); ?></h3>
                    <h5 class="tx-15"><?php echo e($value->nama_nutrisi); ?></h5>
                    <p class="text-muted"><?php echo e($value->satuan); ?></p>
                  </div>
                </div>
              </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>
        </div>
        <div class="col-md-7">
          <?php if($data['status_komposisi'] == 0 ): ?>
          <div class="bg-gray-700 pd-30 ht-100p" style="border-radius:0 20px 20px 0">
            <div class="row mg-b-15">
              <div class="col-md-6">
                <h5 class="tx-white">Proses Produksi</h5>
              </div>
              <div class="col-md-6">
                <?php if(!empty($data['status-produksi'])): ?>
                  <?php if($data['status-produksi']->id == 5 ): ?>
                    <a class="btn btn-xs btn-primary pull-right" href="<?php echo e(route('detail_jadwal_menu',['id'=>$data['jadwal-menu']->id,'page'=>'form-pengiriman'])); ?>" ><?php echo e($data['status-produksi']->button); ?></a>
                  <?php else: ?>
                    <button class="btn btn-xs btn-primary pull-right" data-target = "#modal-proses-pengolahan" data-toggle="modal" ><?php echo e($data['status-produksi']->button); ?></button>
                  <?php endif; ?>
                <?php endif; ?>
              </div>
            </div>
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body">
                <div class="timeline-group tx-13">
                  <?php $__currentLoopData = $data['proses-pengolahan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="timeline-label"><?php echo e(GlobalHelper::tgl_indo($value->tanggal)); ?></div>
                    <?php $__currentLoopData = $value->timeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="timeline-item">
                        <div class="timeline-time"><?php echo e(GlobalHelper::dateFormat($value2->created_at,'H:i')); ?></div>
                        <div class="timeline-body">
                          <h6 class="mg-b-0"><?php echo e($value2->status_produksi); ?></h6>
                          <p class="mg-b-5"><?php echo e((!empty($value2->keterangan) ? $value2->keterangan : 'Tidak ada Catatan' )); ?></p>
                          <?php if($value2->status == 1 ): ?>
                            <button class="btn btn-primary btn-xs">Ubah Catatan</button>
                            <button class="btn btn-danger btn-xs" onclick="batalkanProses(<?php echo e($value2->id); ?>)">Batalkan Proses</button>
                            <form action="<?php echo e(route('proses_pengolahan_makanan',['jadwal_menu'=>$id,'status'=>(!empty($data['status-produksi']) ? $data['status-produksi']->id : null )])); ?>" method="post" id="batalkan<?php echo e($value2->id); ?>">
                              <?php echo e(csrf_field()); ?>

                              <input type="hidden" name="id" value="<?php echo e($value2->id); ?>">
                              <input type="hidden" name="action" value="delete">
                            </form>
                          <?php endif; ?>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
            <div class="row row-sm mg-t-20">
          <div class="col-md-6">
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body tx-center">
                <h6>Pencucian Alat Makan</h6>
                <div id="progres_cuci_piring"></div>
                <div class="row row-xs mg-t-30">
                  <div class="col-md-6">
                    <button class="btn btn-primary btn-block btn-xs" data-target = "#modal-proses-pencucian" data-toggle="modal">Tambahkan<br>Proses</button>
                  </div>
                  <div class="col-md-6">
                    <button class="btn btn-secondary btn-block btn-xs" data-target = "#modal-tampilkan-proses-pencucian" data-toggle="modal">Tampilkan<br>Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card rounded-10 mg-b-10 bg-gray-100">
              <div class="card-body tx-center">
                <h6>Pemorsian / Pengepakan</h6>
                <div id="progres_pengemasan"></div>
                <div class="row row-xs mg-t-30">
                  <div class="col-md-6">
                    <button class="btn btn-primary btn-block btn-xs" data-target = "#modal-proses-pengepakan" data-toggle="modal">Tambahkan<br>Proses</button>
                  </div>
                  <div class="col-md-6">
                    <button class="btn btn-secondary btn-block btn-xs" data-target = "#modal-tampilkan-proses-pengepakan" data-toggle="modal">Tampilkan<br>Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
          </div>
          <?php else: ?>
          <div class="bg-gray-300 pd-50 ht-100p" style="border-radius:0 20px 20px 0">
            <div class="tx-center mg-t-50">
              <img src="<?php echo e(asset('assets/images/groceries.png')); ?>" style="width:200px">
              <h4 class="mg-t-20">MENU MAKANAN BELUM BISA DIPROSES</h4>
              <p>Bahan baku tidak mencukupi untuk memproses menu makanan ini, segera melakukan pembelian atau restok bahan baku</p>
            </div>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>

  <?php if($page != 'form-pengiriman'): ?>

  <div class="modal fade" id="modal-proses-pengolahan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Konfirmasi Proses Pengolahan</h5>
          <p><?php echo e((!empty($data['status-produksi']) ? $data['status-produksi']->pertanyaan.'?' : null )); ?></p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_pengolahan_makanan',['jadwal_menu'=>$id,'status'=>(!empty($data['status-produksi']) ? $data['status-produksi']->id : null )])); ?>" method="post" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="form-group">
              <label>Keterangan</label>
              <textarea class="form-control" name="keterangan"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-proses-pencucian" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Proses Pencucian Alat Makan</h5>
          <p>Masukkan jumlah alat makan yang sudah diproses</p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_counter_dapur',['jenis'=>'pencucian','jadwal_menu'=>$id])); ?>" method="post" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Total Alat Makan</label>
                  <input type="text" class="form-control" value="<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$id)['total']); ?>" disabled >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Sudah Dicuci</label>
                  <input type="text" class="form-control" value="<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$id)['sudah']); ?>" disabled >
                </div>
              </div>
            </div>
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Belum Dicuci</label>
                  <input type="text" class="form-control" name="belum" value="<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$id)['belum']); ?>" readonly >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Barusan Dicuci</label>
                  <input type="text" class="form-control" name="jumlah"  >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-tampilkan-proses-pencucian" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Data Progress Pencucian Alat Makan</h5>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pd-0">
          <div class="card-table">
            <table class="table" style="margin-top:0px !important ;">
              <thead class="thead-light">
                <tr>
                  <th width="50px">No</th>
                  <th width="150px">Waktu</th>
                  <th class="tx-center">Jumlah</th>
                  <th>Petugas</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $data['counter-pencucian']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($key+1); ?></td>
                    <td><?php echo e(GlobalHelper::dateFormat($value->created_at,'d/m/Y, H:i')); ?></td>
                    <td style="width:1px;white-space:nowrap" class="tx-center"><?php echo e($value->jumlah); ?></td>
                    <td><?php echo e($value->created_by); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
          <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
        </div>
      </div>
    </div>
  </div>


  <div class="modal fade" id="modal-proses-pengepakan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Proses Pengepakan Makanan</h5>
          <p>Masukkan jumlah porsi makanan yang sudah dikemas</p>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('proses_counter_dapur',['jenis'=>'pengepakan','jadwal_menu'=>$id])); ?>" method="post" enctype="multipart/form-data">
          <?php echo e(csrf_field()); ?>

          <div class="modal-body">
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Total Porsi</label>
                  <input type="text" class="form-control" value="<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$id)['total']); ?>" disabled >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Sudah Dikemas</label>
                  <input type="text" class="form-control" value="<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$id)['sudah']); ?>" disabled >
                </div>
              </div>
            </div>
            <div class="row row-sm">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Belum Dikemas</label>
                  <input type="text" class="form-control" name="belum" value="<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$id)['belum']); ?>" readonly >
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Barusan Dikemas</label>
                  <input type="text" class="form-control" name="jumlah"  >
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
            <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-tampilkan-proses-pengepakan" role="dialog">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <div>
          <h5 class="modal-title">Data Progress Pengepakan Makanan</h5>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pd-0">
          <div class="card-table">
            <table class="table" style="margin-top:0px !important ;">
              <thead class="thead-light">
                <tr>
                  <th width="50px">No</th>
                  <th width="150px">Waktu</th>
                  <th class="tx-center">Jumlah</th>
                  <th>Petugas</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $data['counter-pengepakan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($key+1); ?></td>
                    <td><?php echo e(GlobalHelper::dateFormat($value->created_at,'d/m/Y, H:i')); ?></td>
                    <td style="width:1px;white-space:nowrap" class="tx-center"><?php echo e($value->jumlah); ?></td>
                    <td><?php echo e($value->created_by); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-dark" data-dismiss="modal">Batalkan</button>
          <button type="submit" class="btn btn-primary" name="action" value="add">Simpan</button>
        </div>
      </div>
    </div>
  </div>

  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>
  get_chart_progres_cuci_piring(<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$id)['persentase']); ?>);
  function get_chart_progres_cuci_piring(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["<?php echo e(GlobalHelper::get_counter_dapur('pencucian',$id)['color']); ?>"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_cuci_piring"), options);
    chart.render();
  }

  get_chart_progres_pengemasan(<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$id)['persentase']); ?>);
  function get_chart_progres_pengemasan(progress){
    var options = {
      chart: {
        height: 280,
        type: "radialBar",
      },
      series: [progress],
      colors: ["<?php echo e(GlobalHelper::get_counter_dapur('pengepakan',$id)['color']); ?>"],
      plotOptions: {
        radialBar: {
          startAngle: -120,
          endAngle: 120,
          track: {
            background: '#2c3e50',
            startAngle: -120,
            endAngle: 120,
          },
          dataLabels: {
            name: {
              show: false,
            },
            value: {
              fontSize: "30px",
              show: true
            }
          }
        }
      },
      stroke: {
        lineCap: "round"
      },
      labels: ["Progress"]
    };

    var chart = new ApexCharts(document.querySelector("#progres_pengemasan"), options);
    chart.render();
  }

  function batalkanProses(id){
    swal({
       title: "Are you sure?",
       text: "Apakah anda yakin ingin membatalkan proses ini",
       icon: "warning",
       buttons: true,
       dangerMode: true,
     })
     .then((willDelete) => {
      if (willDelete) {
        $('#batalkan'+id).submit();
      }
    });
  }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/dapur/jadwal/detail/index.blade.php ENDPATH**/ ?>