<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}
#marker {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  background:url('<?php echo e(asset('assets/images/location.png')); ?>') no-repeat top center;
  background-size:100%;
  opacity: 1;
  cursor: move;
  z-index: 9000
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="card ht-100p rounded-20">
    <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
      <h4 class="mg-b-0">Penerima Manfaat Makanan Bergizi</h4>
    </div>
    <div class="card-body">
      <div class="row">
        <div class="col-md-6">
          <div class="card rounded-10 ht-100p">
            <div class="card-body">
              <div class="" id="pie_jumlah_siswa"></div>
            </div>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card rounded-10">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/school.png')); ?>" class="mg-r-10" style="width:80px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e($data['jumlah-sekolah']); ?></h6>
                  <div class="tx-18 tx-gray-600">Jumlah Sekolah</div>
                </div>
              </div>
            </div>
          </div>
          <div class="card rounded-10 mg-t-30">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/students.png')); ?>" class="mg-r-10" style="width:80px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e($data['jumlah-siswa']); ?></h6>
                  <div class="tx-18 tx-gray-600">Total Peserta Didik</div>
                </div>
              </div>
            </div>
          </div>
          <div class="card rounded-20 mg-t-30">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/male-student.png')); ?>" class="mg-r-10" style="width:80px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e(GlobalHelper::get_jumlah_siswa('all','laki_laki')); ?></h6>
                  <div class="tx-18 tx-gray-600">Siswa Laki-laki</div>
                </div>
              </div>
            </div>
          </div>
          <div class="card rounded-20 mg-t-30">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/female-student.png')); ?>" class="mg-r-10" style="width:80px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e(GlobalHelper::get_jumlah_siswa('all','perempuan')); ?></h6>
                  <div class="tx-18 tx-gray-600">Siswa Perempuan</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="https://cdn.jsdelivr.net/npm/ol@v9.0.0/dist/ol.js"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>

  get_pie_jumlah_siswa(<?php echo e($data['jumlah-laki-laki']); ?>,<?php echo e($data['jumlah-perempuan']); ?>);
  function get_pie_jumlah_siswa(laki_laki,perempuan){
    var options = {
      series: [laki_laki,perempuan],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 0.8,
          donut: {
            size: '50%'
          }
        }
      },
      labels: ["Laki-Laki", "Perempuan"],
  		colors: ["#2d98da","#ef5777"],
      legend: {
        show: true,
        position: 'bottom'
      }
    };
    var chart = new ApexCharts(document.querySelector("#pie_jumlah_siswa"), options);
    chart.render();
  }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/dashboard/penerima_manfaat.blade.php ENDPATH**/ ?>