<?php $__env->startSection('content'); ?>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" name="search" value="<?php echo e($search); ?>" placeholder="Cari Data Pengiriman Makanan">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px">No</th>
            <th>Waktu</th>
            <th>Menu Makanan</th>
            <th>Tujuan Sekolah</th>
            <th>Nama Pengemudi</th>
            <th class="tx-center">Status</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $data['pengiriman-makanan']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['pengiriman-makanan']->firstItem() + $key); ?></td>
              <td><?php echo e(GlobalHelper::dateFormat($value->tanggal,'d-m-Y')); ?><br><?php echo e(GlobalHelper::dateFormat($value->created_at,'H:i')); ?> WIB</td>
              <td>
                <h6><?php echo e($value->nama_menu); ?></h6>
                <div class="text-truncated-1"><?php echo e($value->jumlah); ?> Porsi</div>
              </td>
              <td>
                <h6><?php echo e($value->nama_sekolah); ?></h6>
                <div><?php echo (!empty($value->alamat) ? $value->alamat : '---' ); ?>, RT <?php echo e($value->rt); ?> / RW <?php echo e($value->rw); ?></div>
              </td>
              <td>
                <h6><?php echo e($value->nama_lengkap); ?></h6>
              </td>
              <td class="tx-center"><?php echo e($value->status); ?></td>
              <td style="width:1px;white-space:nowrap;">
                <a href="<?php echo e(route('detail_pengiriman',['id'=>$value->id])); ?>" class="button dark ripple-effect ico">
                  <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete(<?php echo e($value->id); ?>)" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="<?php echo e(route('proses_penerima_manfaat')); ?>" method="post" id="hapus<?php echo e($value->id); ?>">
                  <?php echo e(csrf_field()); ?>

                  <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20"><?php echo e($data['pengiriman-makanan']->links('include.pagination', ['pagination' => $data['pengiriman-makanan']] )); ?></div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/pengiriman_makanan/index.blade.php ENDPATH**/ ?>