<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}
#marker {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  background:url('<?php echo e(asset('assets/images/location.png')); ?>') no-repeat top center;
  background-size:100%;
  opacity: 1;
  cursor: move;
  z-index: 9000
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="card rounded-20 ht-100p">
    <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
      <h4 class="mg-b-0">Pasokan Bahan Baku Makanan Bergizi</h4>
    </div>
    <div class="card-body">
      <div class="row row-sm">
        <div class="col-md-6">
          <div class="card rounded-10 ht-100p mg-b-30">
            <div class="card-body">
              <div class="d-flex justify-content-center flex-fill">
                <div class="mg-b-20" id="pie_stok_bahan_baku"></div>
              </div>
              <ul class="list-inline justify-content-center d-flex mg-b-20">
                <li class="list-inline-item d-flex align-items-center">
                  <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#16a085"></span>
                  <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Cukup</span>
                </li>
                <li class="list-inline-item d-flex align-items-center mg-l-10">
                  <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#f39c12"></span>
                  <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Rendah</span>
                </li>
                <li class="list-inline-item d-flex align-items-center mg-l-10">
                  <span class="d-block wd-10 ht-10 rounded mg-r-5" style="background:#c0392b"></span>
                  <span class="tx-sans tx-uppercase tx-10 tx-medium tx-color-03">Kritis</span>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-md-6">
          <div class="card rounded-10 mg-b-20">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/bahan-baku-2.png')); ?>" class="mg-r-20" style="width:70px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e(GlobalHelper::jumlah_bahan_baku('all')); ?></h6>
                  <div class="tx-15 tx-gray-600">Total Bahan Baku</div>
                </div>
              </div>
            </div>
          </div>
          <div class="card rounded-10 mg-b-20">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/supplier.png')); ?>" class="mg-r-20" style="width:70px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0"><?php echo e($data['jumlah-supplier']); ?></h6>
                  <div class="tx-15 tx-gray-600">Total Pemasok</div>
                </div>
              </div>
            </div>
          </div>
          <div class="card rounded-10">
            <div class="card-body">
              <div class="media">
                <img src="<?php echo e(asset('assets/images/order.png')); ?>" class="mg-r-20" style="width:70px">
                <div class="media-body align-self-center ">
                  <h6 class="tx-30 mb-0">10</h6>
                  <div class="tx-15 tx-gray-600">Total Pesanan Berlangsung</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row row-sm">
        <?php $__currentLoopData = $data['bahan-baku']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-md-6">
          <div class="card rounded-10 mg-t-20">
            <div class="card-body pd-10">
              <div class="media">
                <div class="image-wrapper rounded-10 mg-r-10 " style="aspect-ratio:1/1;width:70px;">
                  <img class="rounded-10" src="<?php echo e((!empty($value->gambar) ? asset('storage/'.$value->gambar) : asset('assets/images/image-default.jpg') )); ?>" alt="">
                </div>
                <div class="media-body align-self-center ">
                  <p class="tx-medium mg-b-0"><?php echo e($value->nama_bahan); ?></p>
                  <small class="tx-13 tx-gray-500 mg-b-0"><?php echo e($value->nama_kategori); ?></small>
                </div>
              </div>
            </div>
            <div class="card-footer pd-0">
              <div class="pd-x-10 pd-t-10">
                <div class="d-flex">
                  <div class="flex-grow-1">
                    <span class="tx-11 tx-white rounded pd-x-8 pd-y-3" style="background:<?php echo e($value->color); ?>"><?php echo e($value->status); ?></span>
                  </div>
                  <a href="<?php echo e(route('detail_bahan_baku',['id'=>$value->id,'tab'=>'pembelian','mode'=>'order'])); ?>" class="align-self-center link-03 tx-12">Pesan Sekarang <i class="icon ion-md-arrow-forward mg-l-5"></i></a>
                </div>
              </div>
              <hr style="margin-top: 0.7rem;margin-bottom: 0px;">
              <div class="pd-10">
                <div class="d-flex">
                  <div class="flex-grow-1">
                    <div class="tx-11 tx-gray-700">Sisa Stok</div>
                    <h6 class="tx-12"><?php echo e($value->stok); ?> <?php echo e($value->satuan); ?></h6>
                  </div>
                  <div>
                    <div class="tx-11 tx-gray-700">Kekurangan Stok</div>
                    <h6 class="tx-12"><?php echo e($value->kekurangan_stok); ?> <?php echo e($value->satuan); ?></h6>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="https://cdn.jsdelivr.net/npm/ol@v9.0.0/dist/ol.js"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>
  get_pie_stok_bahan_baku(<?php echo e(GlobalHelper::jumlah_bahan_baku('normal')); ?>,<?php echo e(GlobalHelper::jumlah_bahan_baku('rendah')); ?>,<?php echo e(GlobalHelper::jumlah_bahan_baku('kritis')); ?>);
  function get_pie_stok_bahan_baku(cukup,rendah,kritis){
    var options = {
      series: [cukup,rendah,kritis],
      chart: {
  			type: "donut",
  			sparkline: {
  				enabled: !0
  			}
  		},
      plotOptions: {
        pie: {
          customScale: 1,
          donut: {
            size: '40%'
          }
        }
      },
      labels: ["Cukup", "Rendah", "Kritis"],
  		colors: ["#16a085","#f39c12","#c0392b"]
    };
    var chart = new ApexCharts(document.querySelector("#pie_stok_bahan_baku"), options);
    chart.render();
  }

  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/dashboard/bahan_baku.blade.php ENDPATH**/ ?>