<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
<style>
.rounded-20 .card-header:first-child{
  border-radius: 20px 20px 0 0;
}

.rounded-10 .card-header:first-child{
  border-radius: 10px 10px 0 0;
}

.rounded-10 .card-footer:last-child{
  border-radius: 0 0 10px 10px;
}

.divider-vertical {
  flex-direction: column;
  margin: 0 10px;
}
.divider-vertical::before {
  margin-right: 0;
  margin-bottom: 0px;
}
.divider-vertical::after {
  margin-left: 0;
  margin-top: 0px;
}
#marker {
  width: 40px;
  height: 40px;
  border-radius: 10px;
  background:url('<?php echo e(asset('assets/images/location.png')); ?>') no-repeat top center;
  background-size:100%;
  opacity: 1;
  cursor: move;
  z-index: 9000
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="card ht-100p rounded-20">
    <div class="card-header pd-y-20 d-md-flex align-items-center justify-content-between">
      <h4 class="mg-b-0">Distribusi Makanan Bergizi</h4>
    </div>
    <div class="card-body pd-10">
      <div id="map" class="rounded-20 bg-gray-500 ht-100p"></div>
      <div id="marker"></div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDymbs_1T1obAHoub1_27J5sj-cG_q0pIs"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>
  $(document).ready(function () {
      let dapur = { lat: -7.427628551783064, lng: 112.70805805303137 };
      <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      let sekolah<?php echo e($value->id); ?> = { lat: <?php echo e($value->latitude); ?>, lng: <?php echo e($value->longitude); ?> };
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      const mapOptions = {
          center: dapur,
          zoom: 10,
      };

      const map = new google.maps.Map(document.getElementById('map'), mapOptions);

      <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        const directionsService<?php echo e($value->id); ?> = new google.maps.DirectionsService();
        const directionsRenderer<?php echo e($value->id); ?> = new google.maps.DirectionsRenderer({
            map: map,
            polylineOptions: {
                strokeColor: "<?php echo e($value->color); ?>",
                strokeOpacity: 0.5,
                strokeWeight: 7
            }
        });
        const request<?php echo e($value->id); ?> = {
            origin: dapur,
            destination: sekolah<?php echo e($value->id); ?>,
            travelMode: google.maps.TravelMode.DRIVING,
        };
        directionsService<?php echo e($value->id); ?>.route(request<?php echo e($value->id); ?>, function (result, status) {
          if (status === google.maps.DirectionsStatus.OK) {
              directionsRenderer<?php echo e($value->id); ?>.setDirections(result);

              const route = result.routes[0].legs[0];
              const distance = route.distance.text;
              const duration = route.duration.text;

              const info = `Distance: ${distance}, Estimated Time: ${duration}`;
          } else {
              console.error("Directions request failed due to " + status);
          }
        });
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  });


  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rantai_pasok/code/resources/views/dashboard/distribusi.blade.php ENDPATH**/ ?>