<?php $__env->startSection('content'); ?>
  <div class="row row-sm mg-b-20">
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="<?php echo e(asset('assets/images/school.png')); ?>" class="mg-r-10" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0"><?php echo e($data['jumlah-sekolah']); ?></h6>
              <div class="tx-gray-600">Jumlah Sekolah</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="<?php echo e(asset('assets/images/students.png')); ?>" class="mg-r-10" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0"><?php echo e(GlobalHelper::get_jumlah_siswa('all','all')); ?></h6>
              <div class="tx-gray-600">Jumlah Siswa</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="<?php echo e(asset('assets/images/male-student.png')); ?>" class="mg-r-10" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0"><?php echo e(GlobalHelper::get_jumlah_siswa('all','laki_laki')); ?></h6>
              <div class="tx-gray-600">Siswa Laki-laki</div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card rounded-20">
        <div class="card-body">
          <div class="media">
            <img src="<?php echo e(asset('assets/images/female-student.png')); ?>" class="mg-r-10" style="width:60px">
            <div class="media-body align-self-center ">
              <h6 class="tx-20 mb-0"><?php echo e(GlobalHelper::get_jumlah_siswa('all','perempuan')); ?></h6>
              <div class="tx-gray-600">Siswa Perempuan</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="card card-table rounded-20">
    <div class="card-body">
      <div class="pd-30">
        <div class="row row-sm">
          <div class="col-md-8">
            <form action="" method="get">
              <div class="search-form">
                <input type="search" class="form-control" autocomplete="off" name="search" value="<?php echo e($search); ?>" placeholder="Cari Data Penerima Manfaat">
                <button class="btn" type="submit"><i data-feather="search"></i></button>
              </div>
            </form>
          </div>
          <div class="col-md-4">
            <a class="btn btn-primary pull-right" href="<?php echo e(route('form_penerima_manfaat')); ?>" >Tambah Penerima Manfaat</a>
          </div>
        </div>
      </div>
      <table class="table table-vertical-middle">
        <thead class="thead-light">
          <tr>
            <th width="50px" rowspan="2">No</th>
            <th rowspan="2">Nama Sekolah</th>
            <th rowspan="2">Alamat</th>
            <th colspan="3" class="tx-center" style="border-bottom: 1px solid #c5ccd7;">Jumlah Siswa</th>
            <th rowspan="2"></th>
          </tr>
          <tr>
            <th class="tx-center" width="100px">Laki-laki</th>
            <th class="tx-center" width="100px">Perempuan</th>
            <th class="tx-center" width="100px">Total</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $data['penerima-manfaat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($data['penerima-manfaat']->firstItem() + $key); ?></td>
              <td style="width:300px">
                <div class="media">
                  <div class="image-wrapper rounded mg-r-10 " style="aspect-ratio:1/1;width:60px;padding:3px">
                    <img src="<?php echo e((!empty($value->logo) ? asset('storage/'.$value->logo) : asset('assets/images/image-default.jpg') )); ?>" alt="">
                  </div>
                  <div class="media-body align-self-center ">
                    <h6><?php echo e($value->nama_sekolah); ?></h6>
                    <div>NPSN.<?php echo e($value->npsn); ?></div>
                  </div>
                </div>
              </td>
              <td>
                <div><?php echo (!empty($value->alamat) ? $value->alamat : '---' ); ?>, RT <?php echo e($value->rt); ?> / RW <?php echo e($value->rw); ?></div>
                <h6></h6>
              </td>
              <td class="tx-center"><?php echo e($value->jumlah_laki_laki); ?></td>
              <td class="tx-center"><?php echo e($value->jumlah_perempuan); ?></td>
              <td class="tx-center"><?php echo e($value->total); ?></td>
              <td style="width:1px;white-space:nowrap;">
                <a href="<?php echo e(route('detail_penerima_manfaat',['id'=>$value->id])); ?>" class="button dark ripple-effect ico">
                  <i data-feather="search" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="<?php echo e(route('form_penerima_manfaat',['id'=>$value->id])); ?>" class="button green ripple-effect ico">
                  <i data-feather="edit" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <a href="javascript:;" onclick="confirmDelete(<?php echo e($value->id); ?>)" class="button red ripple-effect ico">
                  <i data-feather="trash" class="tx-white-8 wd-20 ht-20 "></i>
                </a>
                <form action="<?php echo e(route('proses_penerima_manfaat')); ?>" method="post" id="hapus<?php echo e($value->id); ?>">
                  <?php echo e(csrf_field()); ?>

                  <input type="hidden" name="id" value="<?php echo e($value->id); ?>">
                  <input type="hidden" name="action" value="delete">
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="pd-x-30 pd-y-20"><?php echo e($data['penerima-manfaat']->links('include.pagination', ['pagination' => $data['penerima-manfaat']] )); ?></div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/penerima_manfaat/index.blade.php ENDPATH**/ ?>