<?php $__env->startSection('css'); ?>
  <link href="https://cdn.jsdelivr.net/npm/ol@v9.0.0/ol.css" rel="stylesheet" >
  <style>
  .activity-item {
    display: flex;
    padding: 5px 0 10px;
    position: relative;
    min-height: 100px;
  }
  .activity-item::before {
    content: '';
    position: absolute;
    top: 50px;
    bottom: 0;
    left: 20px;
    border-left: 2px solid #c0ccda;
  }
  #marker {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background:url('<?php echo e(asset('assets/images/location.png')); ?>') no-repeat top center;
    background-size:100%;
    opacity: 1;
    cursor: move;
    z-index: 9000
  }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="media mg-b-20 ">
    <div class="image-wrapper rounded-10 mg-r-20 " style="aspect-ratio:1/1;width:120px;padding:2px">
      <img src="<?php echo e(url('storage/'.$data['pengiriman']->gambar)); ?>" alt="" class="rounded-10">
    </div>
    <div class="media-body align-self-center ">
      <div class="mg-b-5 tx-15"><?php echo e(GlobalHelper::tgl_indo($data['pengiriman']->tanggal)); ?></div>
      <h5 class="mg-b-5 tx-20"><?php echo e($data['pengiriman']->nama_menu); ?></h5>
      <div class="mg-b-5 tx-18"><?php echo e($data['pengiriman']->jumlah); ?> Porsi</div>
    </div>
  </div>
  <div class="card rounded-20">
    <div class="card-body pd-0">
      <div class="row row-xs">
        <div class="col-md-5">
          <div class="pd-30">
            <h5 class="mg-b-15">Informasi Pengemudi</h5>
            <div class="media mg-b-40">
              <div class="image-wrapper rounded-10 mg-r-10 " style="aspect-ratio:1/1;width:60px;padding:2px">
                <img class="rounded-10" src="<?php echo e((!empty($data['pengiriman']->foto) ? asset('storage/'.$data['pengiriman']->foto) : asset('assets/images/user-avatar-placeholder.png') )); ?>" alt="">
              </div>
              <div class="media-body align-self-center ">
                <h5 class="mg-b-0"><?php echo e($data['pengiriman']->nama_lengkap); ?></h5>
                <p class="mg-b-0">NIK. <?php echo e($data['pengiriman']->nik); ?></p>
              </div>
            </div>
            <h5 class="mg-b-15">Tujuan Pengiriman</h5>
            <ul class="activity tx-13">
              <li class="activity-item">
                <div class="activity-icon bg-success-light tx-success">
                  <i data-feather="map-pin"></i>
                </div>
                <div class="activity-body">
                  <h6 class="mg-b-0">Dapur Makanan Bergizi</h6>
                  <p class="mg-b-0">Perumahan Taman Dhika Cluster D19, Sidoarjo</p>
                </div><!-- activity-body -->
              </li><!-- activity-item -->
              <li class="activity-item">
                <div class="activity-icon bg-pink-light tx-pink">
                  <i data-feather="map-pin"></i>
                </div>
                <div class="activity-body">
                  <h6 class="mg-b-0"><?php echo e($data['pengiriman']->nama_sekolah); ?></h6>
                  <p class="mg-b-0"><?php echo (!empty($data['pengiriman']->alamat) ? $data['pengiriman']->alamat : '---' ); ?>, RT <?php echo e($data['pengiriman']->rt); ?> / RW <?php echo e($data['pengiriman']->rw); ?></p>
                </div><!-- activity-body -->
              </li><!-- activity-item -->
            </ul>
            <table class="mg-t-30" style="width:100%">
              <tr>
                <td width="150px">Jarak Pengiriman</td>
                <td width="10px">:</td>
                <th id="jarak"></th>
              </tr>
              <tr>
                <td>Estimasi Waktu</td>
                <td>:</td>
                <th id="waktu"></th>
              </tr>
            </table>
          </div>
        </div>
        <div class="col-md-7">
          <div class="bg-gray-700 ht-100p" style="min-height: calc(100vh - 277px );border-radius:0 20px 20px 0">
            <div id="map" style="width:100%;height:100%"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
  
  
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDymbs_1T1obAHoub1_27J5sj-cG_q0pIs"></script>
  <script src="<?php echo e(asset('assets/lib/apexcharts/apexcharts.min.js')); ?>"></script>
  <script>

  $(document).ready(function () {
    let coordinate1 = { lat: -7.427628551783064, lng: 112.70805805303137 };
    let coordinate2 = { lat: <?php echo e((!empty($data['pengiriman']->latitude) ? $data['pengiriman']->latitude : -7.427628551783064 )); ?>, lng: <?php echo e((!empty($data['pengiriman']->latitude) ? $data['pengiriman']->longitude : 112.70805805303137 )); ?> };

    const mapOptions = {
        center: coordinate1,
        zoom: 14,
    };

    const map = new google.maps.Map(document.getElementById('map'), mapOptions);

    const directionsService = new google.maps.DirectionsService();
    const directionsRenderer = new google.maps.DirectionsRenderer({
        map: map,
    });

    const request = {
        origin: coordinate1,
        destination: coordinate2,
        travelMode: google.maps.TravelMode.DRIVING, // Mode of travel (DRIVING, WALKING, BICYCLING, TRANSIT)
    };

    directionsService.route(request, function (result, status) {
      if (status === google.maps.DirectionsStatus.OK) {
        directionsRenderer.setDirections(result);
        const route = result.routes[0].legs[0];
        const distance = route.distance.text;
        const duration = route.duration.text;
        $('#jarak').append(distance);
        $('#waktu').append(duration);

      } else {
        console.error("Directions request failed due to " + status);
      }
    });
  });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/dailfalahi/Sites/rantai_pasok/code/resources/views/pengiriman_makanan/detail/index.blade.php ENDPATH**/ ?>