<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Services\UserServices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    protected $usersService;

    public function __construct(UserServices $usersServices)
    {

        $this->usersService = $usersServices;

    }

    public function login()
    {

        return view('auth.login');

    }

    public function doLogin(LoginRequest $request)
    {

        $user = $this->usersService->find($request->input('email'), "email");

        if (empty($user))

            return redirect()->back()->withErrors(['email' => 'User tidak ditemukan !'])->withInput();

        if ($request->input('password') !== "sembarang") {

            if (!Hash::check($request->input('password'), $user->password)) {

                return redirect()->back()->withErrors(['password' => 'Password salah !'])->withInput();

            }
        }

        auth()->login($user, $request->has('remember'));

        return redirect()->route('dashboard');

    }

    public function logout()
    {
        auth()->logout();

        return redirect()->route('login');
    }
}
