<?php

namespace App\Http\Controllers;

use App\Http\Requests\JenisRekomendasiRequest;
use App\Services\JenisRekomendasiServices;
use Illuminate\Http\Request;

class JenisRekomendasiController extends Controller
{
    protected $jenisRekomendasiservices;

    public function __construct()
    {

        $this->jenisRekomendasiservices = new JenisRekomendasiServices();

    }

    public function index(Request $request)
    {
        // TODO: Implement index() method.
        $data = $this->jenisRekomendasiservices->search($request);

        return view('jenis_rekomendasi.index')
            ->with('data', $data);
    }

    public function create()
    {
        return view('jenis_rekomendasi.create');
    }

    public function store(JenisRekomendasiRequest $request)
    {

        $this->jenisRekomendasiservices->create($request->all());


        return redirect()->route('jenis.rekomendasi')
            ->with('icon', 'success')
            ->with('message', 'Save Success');

    }

    public function edit($id)
    {

        $data = $this->jenisRekomendasiservices->find($id);

        return view('jenis_rekomendasi.edit')
            ->with('data', $data);

    }

    public function update(JenisRekomendasiRequest $request, $id)
    {

        $this->jenisRekomendasiservices->update($request->all(), $id);

        return redirect()->route('jenis.rekomendasi')
            ->with('icon', 'success')
            ->with('message', 'Update Success');

    }

    public function delete($id)
    {

        $this->jenisRekomendasiservices->delete($id);

        return redirect()->route('jenis.rekomendasi')
            ->with('icon', 'success')
            ->with('message', 'Delete Success');
    }


}
