<?php

namespace App\Http\Controllers;

use App\Http\Requests\SaveKorbanRequest;
use App\Services\KorbanServices;
use Illuminate\Http\Request;

class KorbanController extends Controller
{
    protected $korbanservices;

    public function __construct()
    {

        $this->korbanservices = new KorbanServices();

    }

    public function index(Request $request)
    {

        $data = $this->korbanservices->search($request);

        return view('korban.index')
            ->with('data', $data);
    }

    public function create()
    {

        return view('korban.create');

    }

    public function store(SaveKorbanRequest $request)
    {

        $this->korbanservices->create($request->all());

        return redirect()->route('korbans')
            ->with('icon', 'success')
            ->with('message', 'Berhasil Disimpan');

    }

    public function edit($id)
    {

        $data = $this->korbanservices->find($id);

        return view('korban.edit')
            ->with('data', $data);

    }

    public function update(Request $request, $id)
    {

        $this->korbanservices->update($request->all(), $id);

        return redirect()->route('korbans')
            ->with('icon', 'success')
            ->with('message', 'Berhasil ubah ');

    }

    public function delete($id)
    {

        $this->korbanservices->delete($id);

        return redirect()->route('korbans')
            ->with('icon', 'success')
            ->with('message', 'Berhasil hapus');
    }

}
