<?php

namespace App\Http\Controllers;

use App\Http\Requests\PelaksanaRequest;
use App\Services\PelaksanaServices;
use Illuminate\Http\Request;

class PelaksanaController extends Controller
{
    protected $pelaksanaServices;

    public function __construct()
    {
        $this->pelaksanaServices = new PelaksanaServices();
    }

    public function index(Request $request)
    {

        $data = $this->pelaksanaServices->search($request);

        return view('pelaksana.index')
            ->with('data', $data);
    }

    public function create()
    {

        return view('pelaksana.create');

    }

    public function store(PelaksanaRequest $request)
    {

        $this->pelaksanaServices->create($request->all());

        return redirect()->route('pelaksana')
            ->with('icon', 'success')
            ->with('message', 'Berhasil Disimpan');

    }

    public function edit($id)
    {

        $data = $this->pelaksanaServices->find($id);

        return view('pelaksana.edit')
            ->with('data', $data);

    }

    public function update(Request $request, $id)
    {

        $this->pelaksanaServices->update($request->all(), $id);

        return redirect()->route('pelaksana')
            ->with('icon', 'success')
            ->with('message', 'Berhasil ubah ');

    }

    public function delete($id)
    {

        $this->pelaksanaServices->delete($id);

        return redirect()->route('pelaksana')
            ->with('icon', 'success')
            ->with('message', 'Berhasil hapus');
    }
}
