<?php

namespace App\Http\Controllers;

use App\Http\Requests\AduanRequest;
use App\Services\AduanServices;
use App\Services\JenisRekomendasiServices;
use App\Services\KorbanServices;
use App\Services\PelaksanaServices;
use Illuminate\Http\Request;

class TindakLanjutController extends Controller
{
    protected $aduanServices, $korbanservices, $jenisRekomendasiServices, $pelaksanaServices;

    public function __construct()
    {
        $this->aduanServices = new AduanServices();

        $this->korbanservices = new KorbanServices();

        $this->jenisRekomendasiServices = new JenisRekomendasiServices();

        $this->pelaksanaServices = new PelaksanaServices();
    }

    public function index(Request $request)
    {

        $data = $this->aduanServices->search($request);

        return view('tindak_lanjut.index')
            ->with('data', $data);
    }

    public function create()
    {
        $korban = $this->korbanservices->all();

        $jenis = $this->jenisRekomendasiServices->all();

        $pelaksana = $this->pelaksanaServices->all();

        return view('aduan.create')
            ->with('pelaksana', $pelaksana)
            ->with('jenis',$jenis)
            ->with('korban',$korban);
    }

    public function store(AduanRequest $request)
    {
        $data = $request->all();

        if ($request->hasFile('dokumen')) {

            $path = $request->file('dokumen')->store('lampiran', 'public');

            $data['file'] = $path;

            unset($data['dokumen']);

        }


        $this->aduanServices->create($data);

        return redirect()->route('aduans')
            ->with('icon', 'success')
            ->with('message', 'Berhasil Disimpan');

    }

    public function edit($id)
    {

        $korban = $this->korbanservices->all();

        $data = $this->aduanServices->find($id);

        $jenis = $this->jenisRekomendasiServices->all();

        $pelaksana = $this->pelaksanaServices->all();

        return view('aduan.edit')
            ->with('pelaksana', $pelaksana)
            ->with('korban',$korban)
            ->with('jenis',$jenis)
            ->with('data', $data);

    }

    public function update(Request $request, $id)
    {
        $aduan = $this->aduanServices->find($id);

        if ($request->hasFile('dokumen')) {

            if ($aduan->file && \Storage::disk('public')->exists($aduan->file)) {
                \Storage::disk('public')->delete($aduan->file);
            }

            // simpan file baru
            $path = $request->file('dokumen')->store('lampiran', 'public');

            $data = $request->all();

            unset($data['dokumen']);

            $data['file'] = $path;

            $this->aduanServices->update($data, $id);

        }else{
            $this->aduanServices->update($request->all(), $id);
        }


        return redirect()->route('aduans')
            ->with('icon', 'success')
            ->with('message', 'Berhasil ubah ');

    }

    public function delete($id)
    {

        $this->aduanServices->delete($id);

        return redirect()->route('users')
            ->with('icon', 'success')
            ->with('message', 'Berhasil hapus');
    }
}
