<?php

namespace App\Http\Controllers;

use App\Services\PelaksanaServices;
use App\Services\UserServices;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UsersController extends Controller
{
    protected $userService, $pelaksanaServices;

    public function __construct()
    {

        $this->userService = new UserServices();

        $this->pelaksanaServices = new PelaksanaServices();
    }

    public function index(Request $request)
    {
        // TODO: Implement index() method.
        $data = $this->userService->search($request);

        return view('user.index')
            ->with('data', $data);
    }

    public function create()
    {
        $pelaksana = $this->pelaksanaServices->all();

        return view('user.create')
            ->with('pelaksana',$pelaksana);

    }

    public function store(Request $request)
    {

        $validated = $request->validate([
            'name' => 'required|min:3|max:50',
            'email' => 'email',
            'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password_confirmation' => 'min:6',
        ]);

        $password = Hash::make($request->input("password"));

        $request->merge(["password" => $password]);

        $this->userService->create($request->all());

        return redirect()->route('users')
            ->with('icon', 'success')
            ->with('message', 'Save Success');

    }

    public function edit($id)
    {
        $pelaksana = $this->pelaksanaServices->all();

        $data = $this->userService->find($id);

        return view('user.edit')
            ->with('pelaksana',$pelaksana)
            ->with('data', $data);

    }

    public function update(Request $request, $id)
    {

        $password = $request->input('password') ?? "";

        if ($password) {

            $request->merge(["password" => Hash::make($password)]);

            $this->userService->update($request->all(), $id);

        } else {

            $this->userService->update($request->only(['name', "email", "role",'pelaksana_id']), $id);

        }

        return redirect()->route('users')
            ->with('icon', 'success')
            ->with('message', 'Update Success');

    }

    public function delete($id)
    {

        $this->userService->delete($id);

        return redirect()->route('users')
            ->with('icon', 'success')
            ->with('message', 'Delete Success');
    }
}
