<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Aduan extends Model
{
    protected $guarded = [];

    protected $appends = ['file_url'];

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub

        static::creating(function ($order) {
            $lastOrder = self::latest('id')->first();
            $nextId = $lastOrder ? $lastOrder->id + 1 : 1;
            $order->nomor = 'HAM-' . str_pad($nextId, 5, '0', STR_PAD_LEFT);
        });
    }

    public function getFileUrlAttribute()
    {
        return $this->file ? asset('storage/'. $this->file) : null;
    }

    public function korban()
    {
        return $this->belongsTo(Korban::class);
    }

    public function jenis_rekomendasi()
    {
        return $this->belongsTo(JenisRekomendasi::class);
    }

    public function pelaksana()
    {
        return $this->belongsTo(Pelaksana::class);
    }
}
