<?php

namespace App\Services;

use App\Models\Aduan;

class AduanServices
{

    protected $aduan;


    public function __construct()
    {
        $this->aduan= new Aduan();
    }

    public function find($value, $column = 'id')
    {

        return $this->aduan->where($column, $value)->first();

    }

    public function search($param)
    {
        $user  = auth()->user();
        $aduan = $this->aduan->with(['korban','jenis_rekomendasi','pelaksana'])->orderBy('id');

        $name = $param['name'] ?? "";
        if ($name !== '')
            $aduan->where('name', 'like', "$name%");

        $email = $param['email'] ?? "";
        if ($email !== '')
            $aduan->where('email', 'like', "$email%");

        $aduan = $aduan->paginate(100);

        return $aduan;
    }

    public function create($param)
    {

        return $this->aduan->create($param);

    }

    public function update($param, $id)
    {

        $aduan = $this->aduan->find($id);

        if ($aduan)

            $aduan->update($param);

        return $aduan;
    }

    public function delete($id)
    {

        $aduan = $this->aduan->find($id);

        if ($aduan)

            $aduan->delete();

        return $aduan;
    }
}
