<?php

namespace App\Services;

use App\Models\JenisRekomendasi;

class JenisRekomendasiServices
{

    protected $jenisRekomendasi;

    public function __construct()
    {
        $this->jenisRekomendasi = new JenisRekomendasi();
    }

    public function find($value, $column = 'id')
    {

        return $this->jenisRekomendasi->where($column, $value)->first();

    }

    public function search($param)
    {

        $jenisRekomendasi = $this->jenisRekomendasi->orderBy('id');

        $nama = $param['nama'] ?? "";
        if ($nama !== '')
            $jenisRekomendasi->where('nama', 'like', "$nama%");

        $jenisRekomendasi = $jenisRekomendasi->paginate(10);

        return $jenisRekomendasi;
    }

    public function create($param)
    {

        return $this->jenisRekomendasi->create($param);

    }

    public function update($param, $id)
    {

        $jenisRekomendasi = $this->jenisRekomendasi->find($id);

        if ($jenisRekomendasi)

            $jenisRekomendasi->update($param);

        return $jenisRekomendasi;
    }

    public function delete($id)
    {

        $jenisRekomendasi = $this->jenisRekomendasi->find($id);

        if ($jenisRekomendasi)

            $jenisRekomendasi->delete();

        return $jenisRekomendasi;
    }

    public function all()
    {

        return $this->jenisRekomendasi->all();

    }

}
