<?php

namespace App\Services;

use App\Models\Korban;

class KorbanServices
{
    protected $korban;

    public function __construct()
    {
        $this->korban = new Korban();
    }

    public function find($value, $column = 'id')
    {

        return $this->korban->where($column, $value)->first();

    }

    public function search($param)
    {

        $korban = $this->korban->orderBy('id');

        $name = $param['name'] ?? "";
        if ($name !== '')
            $korban->where('nama', 'like', "$name%");

        $korban = $korban->paginate(10);
        return $korban;
    }

    public function create($param)
    {

        return $this->korban->create($param);

    }

    public function update($param, $id)
    {

        $korban = $this->korban->find($id);

        if ($korban)

            $korban->update($param);

        return $korban;
    }

    public function delete($id)
    {

        $korban = $this->korban->find($id);

        if ($korban)

            $korban->delete();

        return $korban;
    }

    public function all()
    {

        return $this->korban->all();

    }
}
