<?php

namespace App\Services;

use App\Models\Pelaksana;

class PelaksanaServices
{
    protected $pelaksana;

    public function __construct()
    {
        $this->pelaksana = new Pelaksana();
    }

    public function find($value, $column = 'id')
    {

        return $this->pelaksana->where($column, $value)->first();

    }

    public function search($param)
    {

        $pelaksana = $this->pelaksana->orderBy('id');

        $name = $param['name'] ?? "";
        if ($name !== '')
            $pelaksana->where('nama', 'like', "$name%");

        $pelaksana = $pelaksana->paginate(10);
        return $pelaksana;
    }

    public function create($param)
    {

        return $this->pelaksana->create($param);

    }

    public function update($param, $id)
    {

        $pelaksana = $this->pelaksana->find($id);

        if ($pelaksana)

            $pelaksana->update($param);

        return $pelaksana;
    }

    public function delete($id)
    {

        $pelaksana = $this->pelaksana->find($id);

        if ($pelaksana)

            $pelaksana->delete();

        return $pelaksana;
    }

    public function all()
    {

        return $this->pelaksana->all();

    }
}
