<?php

namespace App\Services;

use App\Models\User;

class UserServices
{

    protected $user;

    public function __construct()
    {
        $this->user = new User();
    }

    public function find($value, $column = 'id')
    {

        return $this->user->where($column, $value)->first();

    }

    public function search($param)
    {

        $user = $this->user->with(['pelaksana'])->orderBy('id');

        $name = $param['name'] ?? "";
        if ($name !== '')
            $user->where('name', 'like', "$name%");

        $role = $param['role'] ?? "";
        if ($role !== '')
            $user->where('role', '=', "$role");

        $user = $user->paginate(10);

        return $user;
    }

    public function create($param)
    {

        return $this->user->create($param);

    }

    public function update($param, $id)
    {

        $user = $this->user->find($id);

        if ($user)

            $user->update($param);

        return $user;
    }

    public function delete($id)
    {

        $user = $this->user->find($id);

        if ($user)

            $user->delete();

        return $user;
    }
}
