<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('aduans', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('korban_id');
            $table->string('lokasi');
            $table->date('tanggal');
            $table->text('deskripsi');
            $table->enum('jenis',['penyiksaan','penghilangan_paksa','pembunuhan']);
            $table->enum('status',['menunggu_verifikasi','ditolak','diterima'])->default('menunggu_verifikasi');
            $table->timestamps();

            $table->foreign('korban_id')->references('id')->on('korbans');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('aduans');
    }
};
