@extends('layouts.layout')
@section('body')
    <div class="card mb-4">
        <h5 class="card-header">Ubah Data Pelanggaran</h5>
        <form class="card-body" action="{{ route('aduans.update',$data->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row g-3">
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Nomor</label>
                        <input type="text"  class="form-control" value="{{ $data->nomor }}" disabled>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Korban</label>
                        <select class="form-control select2" name="korban_id">
                            @foreach($korban as $k)
                                <option @if ( $data->korban_id == $k->id) selected @endif value="{{ $k->id }}">{{ $k->nama }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('jenis_kelamin'))
                            <span class="text-danger">{{ $errors->first('jenis_kelamin') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Rekomendasi Pemulihan</label>
                        <select class="form-control select2" name="jenis_rekomendasi_id">
                            @foreach($jenis as $j)
                                <option @if ( $data->jenis_rekomendasi_id == $j->id) selected @endif value="{{ $j->id }}">{{ $j->nama }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('korban_id'))
                            <span class="text-danger">{{ $errors->first('korban_id') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Rekomendasi Lembaga Penanggung Jaawab</label>
                        <select class="form-control select2" name="pelaksana_id">
                            @foreach($pelaksana as $pl)
                                <option @if ( old('pelaksana_id') == $pl->id) selected @endif value="{{ $pl->id }}">{{ $pl->nama }}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('pelaksana_id'))
                            <span class="text-danger">{{ $errors->first('pelaksana_id') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Jenis Pelanggaran</label>
                        <select class="form-control" name="jenis">
                            <option @if ( old('jenis') == 'penyiksaan') selected @endif value="penyiksaan">Penyiksaan</option>
                            <option @if ( old('jenis') == 'penghilangan_paksa') selected @endif value="penghilangan_paksa">Penghilangan Paksa</option>
                            <option @if ( old('jenis') == 'pembunuhan') selected @endif value="pembunuhan">Pembunuhan </option>
                        </select>
                        @if ($errors->has('jenis'))
                            <span class="text-danger">{{ $errors->first('jenis') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label" >Lokasi Kejadian</label>
                    <input type="text" name="lokasi" class="form-control" value="{{ $data->lokasi }}">
                    @if ($errors->has('lokasi'))
                        <span class="text-danger">{{ $errors->first('lokasi') }}</span>
                    @endif
                </div>
                {{--<div class="col-md-6">
                    <label class="form-label" >Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" value="{{ $data->tanggal }}">
                    @if ($errors->has('nama'))
                        <span class="text-danger">{{ $errors->first('nama') }}</span>
                    @endif
                </div>--}}
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Dokumen</label>
                    <input class="form-control" type="file" name="dokumen" >
                    @if ($errors->has('dokumen'))
                        <span class="text-danger">{{ $errors->first('dokumen') }}</span>
                    @endif
                    @if($data->file_url)
                        <a href="{{ $data->file__url }}" target="_blank">Download</a>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Deskripsi</label>
                    <textarea class="form-control"  rows="3" name="deskripsi">{{ $data->deskripsi }}</textarea>
                    @if ($errors->has('deskripsi'))
                        <span class="text-danger">{{ $errors->first('deskripsi') }}</span>
                    @endif
                </div>
            </div>
            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Simpan</button>
                <a href="{{ route('aduans') }}" class="btn btn-label-secondary">Kembali</a>
            </div>
        </form>
    </div>
@endsection
