@extends('layouts.layout')
@section('body')
    <div class="card mb-4">
        <h5 class="card-header">Tambah korban</h5>
        <form class="card-body" action="{{ route('korbans.store') }}" method="POST">
            @csrf

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label" >NIK</label>
                    <input type="text" name="nik" class="form-control" value="{{ old('nik') }}">
                    @if ($errors->has('nik'))
                        <span class="text-danger">{{ $errors->first('nnik') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" >Nama Lengkap</label>
                    <input type="text" name="nama" class="form-control" value="{{ old('nama') }}">
                    @if ($errors->has('nama'))
                        <span class="text-danger">{{ $errors->first('nama') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Kasus Pelanggaran</label>
                    <input type="text" class="form-control" name="kasus_pelanggaran" aria-label="john.doe"
                           value="{{ old('kasus_pelanggaran') }}">
                    @if ($errors->has('kasus_pelanggaran'))
                        <span class="text-danger">{{ $errors->first('kasus_pelanggaran') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Tahun Keputusan KOMNAS HAM</label>
                    <input type="text" class="form-control" name="tahun_keputusan" aria-label="john.doe"
                           value="{{ old('tahun_keputusan') }}">
                    @if ($errors->has('tahun_keputusan'))
                        <span class="text-danger">{{ $errors->first('tahun_keputusan') }}</span>
                    @endif
                </div>

                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Jenis Kelamin</label>
                        <select class="form-control" name="jenis_kelamin">
                            <option @if (old('jenis_kelamin') == 'L') selected @endif value="L">Laki-Laki</option>
                            <option @if (old('jenis_kelamin') == 'P') selected @endif value="P">Perempuan</option>
                        </select>
                        @if ($errors->has('jenis_kelamin'))
                            <span class="text-danger">{{ $errors->first('jenis_kelamin') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Tempat Lahir</label>
                    <input type="text" class="form-control" name="tempat_lahir"value="{{ old('tempat_lahir') }}">
                    @if ($errors->has('tempat_lahir'))
                        <span class="text-danger">{{ $errors->first('tempat_lahir') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Tanggal Lahir</label>
                    <input type="date" class="form-control" name="tanggal_lahir" value="{{ old('tanggal_lahir') }}">
                    @if ($errors->has('tanggal_lahir'))
                        <span class="text-danger">{{ $errors->first('tanggal_lahir') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Alamat</label>
                    <input type="text" class="form-control" name="alamat" value="{{ old('alamat') }}">
                    @if ($errors->has('alamat'))
                        <span class="text-danger">{{ $errors->first('alamat') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Pekerjaan</label>
                    <input type="text" class="form-control" name="pekerjaan" value="{{ old('pekerjaan') }}">
                    @if ($errors->has('pekerjaan'))
                        <span class="text-danger">{{ $errors->first('pekerjaan') }}</span>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="form-password-toggle">
                        <label class="form-label" for="multicol-confirm-password">Status Korban</label>
                        <select class="form-control" name="status_korban">
                            <option @if (old('status_korban') == 'korban_langsung') selected @endif value="korban_langsung">Korban Langsung</option>
                            <option @if (old('status_korban') == 'ahli_waris') selected @endif value="ahli_waris">Ahli waris</option>
                        </select>
                        @if ($errors->has('status_korban'))
                            <span class="text-danger">{{ $errors->first('status_korban') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label" for="multicol-email">Email</label>
                    <input type="email" class="form-control" name="email" aria-label="john.doe"
                           value="{{ old('email') }}">
                    @if ($errors->has('name'))
                        <span class="text-danger">{{ $errors->first('name') }}</span>
                    @endif
                </div>

            </div>
            <div class="pt-4">
                <button type="submit" class="btn btn-primary me-sm-3 me-1">Simpan</button>
                <a href="{{ route('korbans') }}" class="btn btn-label-secondary">Kembali</a>
            </div>
        </form>
    </div>
@endsection
