@extends('layouts.layout')
@section('body')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Data Korban</h5>
            <div class="d-flex align-items-center gap-2">
                <form method="GET" action="{{ route('korbans') }}" class="d-flex gap-2">
                    <input type="text" name="name" value="{{ request('name') }}" class="form-control"
                        placeholder="Search by name">
                    <button type="submit" class="btn btn-secondary">
                        <i class="bx bx-search"></i>
                    </button>
                </form>
                <a href="{{ route('korbans.create') }}" class="btn btn-primary">
                    <i class="bx bx-plus me-1"></i> Tambah
                </a>
            </div>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID Korban</th>
                        <th>NIK</th>
                        <th>Nama Lengkap</th>
                        <th>Tempat Lahir</th>
                        <th>Tanggal Lahir</th>
                        <th>Jenis Kelamin</th>
                        <th>Kasus Pelanggaran</th>
                        <th>tahun Keputusan Komnas HAM</th>
                        <th>Status Korban</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                    @foreach ($data as $item)
                        <tr>
                            <td>{{ $item->kode_korban }}</td>
                            <td>{{ $item->nik }}</td>
                            <td>{{ $item->nama }}</td>
                            <td>{{ $item->tempat_lahir }}</td>
                            <td>{{ $item->tanggal_lahir }}</td>
                            <td>{{ $item->jenis_kelamin }}</td>
                            <td>{{ $item->kasus_pelanggaran }}</td>
                            <td>{{ $item->tahun_keputusan }}</td>
                            <td>{{ ucwords(str_replace('_', ' ', $item->status_korban)) }}</td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                        data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('korbans.edit', $item->id) }}"><i
                                                class="bx bx-edit-alt me-1"></i>
                                            Edit</a>
                                        <form action="{{ route('korbans.delete', $item->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item show-alert-delete-box"><i
                                                    class="bx bx-trash me-1"></i>
                                                Delete</button>
                                        </form>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-between align-items-center mt-3 px-3">
            <div class="text-muted small">
                Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} users
            </div>
            <div>
                {{ $data->links() }}
            </div>
        </div>
    </div>
@endsection
